/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasException;
import io.atlasmap.core.DefaultAtlasCollectionHelper;
import io.atlasmap.spi.AtlasCollectionHelper;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasFieldActionService;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.spi.AtlasModule;
import io.atlasmap.spi.AtlasModuleDetail;
import io.atlasmap.spi.AtlasModuleMode;
import io.atlasmap.v2.ConstantField;
import io.atlasmap.v2.DataSourceMetadata;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtlasModuleDetail(name="ConstantModule", uri="", modes={"SOURCE"}, dataFormats={}, configPackages={})
public class ConstantModule
implements AtlasModule {
    private static final Logger LOG = LoggerFactory.getLogger(ConstantModule.class);
    private AtlasConversionService conversionService;
    private AtlasFieldActionService fieldActionService;
    private AtlasCollectionHelper collectionHelper;
    private ClassLoader classLoader;

    @Override
    public void init() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void processPreValidation(AtlasInternalSession session) throws AtlasException {
    }

    @Override
    public void processPreSourceExecution(AtlasInternalSession session) throws AtlasException {
    }

    @Override
    public void readSourceValue(AtlasInternalSession session) throws AtlasException {
        Field sourceField = session.head().getSourceField();
        if (!(sourceField instanceof ConstantField)) {
            return;
        }
        if (this.getConversionService() != null && sourceField.getFieldType() != null && sourceField.getValue() != null) {
            sourceField.setValue(this.getConversionService().convertType(sourceField.getValue(), null, this.getConversionService().classFromFieldType(sourceField.getFieldType()), null));
        } else if (sourceField.getFieldType() == null) {
            sourceField.setFieldType(FieldType.STRING);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processed source ConstantField sPath=" + sourceField.getPath() + " sV=" + sourceField.getValue() + " sT=" + (Object)((Object)sourceField.getFieldType()) + " docId: " + sourceField.getDocId());
        }
    }

    @Override
    public void processPostSourceExecution(AtlasInternalSession session) throws AtlasException {
    }

    @Override
    public void processPreTargetExecution(AtlasInternalSession session) throws AtlasException {
        throw new UnsupportedOperationException("ConstantField cannot be placed as a target field");
    }

    @Override
    public void populateTargetField(AtlasInternalSession session) throws AtlasException {
        throw new UnsupportedOperationException("ConstantField cannot be placed as a target field");
    }

    @Override
    public void writeTargetValue(AtlasInternalSession session) throws AtlasException {
        throw new UnsupportedOperationException("ConstantField cannot be placed as a target field");
    }

    @Override
    public void processPostTargetExecution(AtlasInternalSession session) throws AtlasException {
        throw new UnsupportedOperationException("ConstantField cannot be placed as a target field");
    }

    @Override
    public void processPostValidation(AtlasInternalSession session) throws AtlasException {
    }

    @Override
    public AtlasModuleMode getMode() {
        return AtlasModuleMode.SOURCE;
    }

    @Override
    public void setMode(AtlasModuleMode atlasModuleMode) {
    }

    @Override
    public AtlasConversionService getConversionService() {
        return this.conversionService;
    }

    @Override
    public void setConversionService(AtlasConversionService atlasConversionService) {
        this.conversionService = atlasConversionService;
    }

    @Override
    public List<AtlasModuleMode> listSupportedModes() {
        return Arrays.asList(AtlasModuleMode.SOURCE);
    }

    @Override
    public String getDocId() {
        return null;
    }

    @Override
    public void setDocId(String docId) {
    }

    @Override
    public String getUri() {
        return null;
    }

    @Override
    public void setUri(String uri) {
    }

    @Override
    public Boolean isStatisticsSupported() {
        return false;
    }

    @Override
    public Boolean isStatisticsEnabled() {
        return false;
    }

    @Override
    public Boolean isSupportedField(Field field) {
        return field instanceof ConstantField;
    }

    @Override
    public Field cloneField(Field field) throws AtlasException {
        return null;
    }

    @Override
    public AtlasFieldActionService getFieldActionService() {
        return this.fieldActionService;
    }

    @Override
    public void setFieldActionService(AtlasFieldActionService atlasFieldActionService) {
        this.fieldActionService = atlasFieldActionService;
        this.collectionHelper = new DefaultAtlasCollectionHelper(atlasFieldActionService);
    }

    @Override
    public AtlasCollectionHelper getCollectionHelper() {
        return this.collectionHelper;
    }

    @Override
    public String getUriDataType() {
        return null;
    }

    @Override
    public Map<String, String> getUriParameters() {
        return null;
    }

    @Override
    public void setDataSourceMetadata(DataSourceMetadata meta) {
    }

    @Override
    public DataSourceMetadata getDataSourceMetadata() {
        return null;
    }

    @Override
    public void setDocName(String docName) {
    }

    @Override
    public String getDocName() {
        return "Constants";
    }

    @Override
    public ConstantField createField() {
        return new ConstantField();
    }
}

