/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.json.core;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.atlasmap.api.AtlasException;
import io.atlasmap.core.AtlasPath;
import io.atlasmap.spi.AtlasFieldWriter;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldStatus;
import io.atlasmap.v2.FieldType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonFieldWriter
implements AtlasFieldWriter {
    private static final Logger LOG = LoggerFactory.getLogger(JsonFieldWriter.class);
    private ObjectMapper objectMapper = null;
    private ContainerNode<?> rootNode = null;

    public JsonFieldWriter() {
        this.objectMapper = new ObjectMapper().enable(new MapperFeature[]{MapperFeature.BLOCK_UNSAFE_POLYMORPHIC_BASE_TYPES}).setDefaultPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
    }

    public JsonFieldWriter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public ContainerNode<?> getRootNode() {
        return this.rootNode;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void write(AtlasInternalSession session) throws AtlasException {
        Field targetField = session.head().getTargetField();
        if (targetField == null) {
            throw new AtlasException(new IllegalArgumentException("Argument 'jsonField' cannot be null"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Field: " + AtlasModelFactory.toString(targetField));
            LOG.debug("Field type=" + (Object)((Object)targetField.getFieldType()) + " path=" + targetField.getPath() + " v=" + targetField.getValue());
        }
        AtlasPath path = new AtlasPath(targetField.getPath());
        AtlasPath.SegmentContext lastSegment = path.getLastSegment();
        if (this.rootNode == null) {
            this.rootNode = path.hasCollectionRoot() != false ? this.objectMapper.createArrayNode() : this.objectMapper.createObjectNode();
        }
        JsonNode parentNode = this.rootNode;
        AtlasPath.SegmentContext parentSegment = null;
        Iterator<AtlasPath.SegmentContext> iterator = path.getSegments(true).iterator();
        while (iterator.hasNext()) {
            AtlasPath.SegmentContext segment = iterator.next();
            if (!segment.equals(lastSegment)) {
                JsonNode childNode;
                block21: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Now processing parent segment: " + segment);
                    }
                    if (segment.isRoot()) {
                        if (parentNode instanceof ArrayNode) {
                            childNode = parentNode;
                            break block21;
                        } else {
                            parentSegment = segment;
                            continue;
                        }
                    }
                    childNode = this.getChildNode((ContainerNode<?>)parentNode, parentSegment, segment);
                }
                if (childNode == null) {
                    childNode = this.createParentNode((ContainerNode<?>)parentNode, parentSegment, segment, targetField);
                } else if (childNode instanceof ArrayNode) {
                    Integer index = segment.getCollectionIndex();
                    if (index == null) {
                        return;
                    }
                    ArrayNode arrayChild = (ArrayNode)childNode;
                    if (arrayChild.size() < index + 1) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Object Array is too small, resizing to accomodate index: " + index + ", current array: " + arrayChild);
                        }
                        while (arrayChild.size() < index + 1) {
                            arrayChild.addObject();
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Object Array after resizing: " + arrayChild);
                        }
                    }
                    childNode = arrayChild.get(index.intValue());
                }
                if (childNode == null) {
                    return;
                }
                parentNode = (ObjectNode)childNode;
                parentSegment = segment;
                continue;
            }
            if (targetField.getFieldType() == FieldType.COMPLEX) {
                this.createParentNode((ContainerNode<?>)parentNode, parentSegment, segment, targetField);
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Now processing field value segment: " + segment);
            }
            this.writeValue((ContainerNode<?>)parentNode, parentSegment, segment, targetField);
        }
        return;
    }

    private void writeValue(ContainerNode<?> parentNode, AtlasPath.SegmentContext parentSegment, AtlasPath.SegmentContext segment, Field field) throws AtlasException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Writing field value '" + segment + "' in parent node '" + parentSegment + "', parentNode: " + parentNode);
        }
        JsonNode valueNode = this.createValueNode(field);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Value to write: " + valueNode);
        }
        String cleanedSegment = segment.getName();
        if (segment.getCollectionType() != CollectionType.NONE) {
            Integer index;
            ArrayNode arrayChild;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Field type is collection. Fetching array '" + segment + "' from parent '" + parentSegment + "': " + parentNode);
            }
            if ((arrayChild = parentSegment == null && cleanedSegment.isEmpty() && this.rootNode instanceof ArrayNode ? (ArrayNode)parentNode : (ArrayNode)this.getChildNode(parentNode, parentSegment, segment)) == null) {
                if (parentNode instanceof ObjectNode) {
                    arrayChild = ((ObjectNode)parentNode).putArray(cleanedSegment);
                } else if (parentNode instanceof ArrayNode) {
                    arrayChild = ((ArrayNode)parentNode).addArray();
                } else {
                    throw new AtlasException(String.format("Unknown JsonNode type '%s' for segment '%s'", parentNode.getClass(), segment));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Could not find array to place value in, created it in parent: " + parentNode);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Array before placing value: " + arrayChild);
            }
            if ((index = segment.getCollectionIndex()) == null) {
                return;
            }
            if (arrayChild.size() < index + 1) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Value Array is too small, resizing to accomodate index: " + index + ", current array: " + arrayChild);
                }
                while (arrayChild.size() < index + 1) {
                    arrayChild.addNull();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Value Array after resizing: " + arrayChild);
                }
            }
            arrayChild.set(index.intValue(), valueNode);
        } else if (field.getStatus() != FieldStatus.NOT_FOUND) {
            if (parentNode instanceof ArrayNode) {
                ((ArrayNode)parentNode).add(valueNode);
            } else if (parentNode instanceof ObjectNode) {
                ((ObjectNode)parentNode).replace(cleanedSegment, valueNode);
            } else {
                throw new AtlasException(String.format("Unknown JsonNode type '%s' for segment '%s'", parentNode.getClass(), segment));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parent node after value written: " + parentNode);
        }
    }

    private ObjectNode createParentNode(ContainerNode<?> parentNode, AtlasPath.SegmentContext parentSegment, AtlasPath.SegmentContext segment, Field targetField) throws AtlasException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating parent node '" + segment + "' under previous parent '" + parentSegment + "' (" + parentNode.getClass().getName() + ")");
        }
        ObjectNode childNode = null;
        String cleanedSegment = segment.getName();
        if (segment.getCollectionType() != CollectionType.NONE) {
            ArrayNode arrayChild;
            if (parentNode instanceof ObjectNode) {
                arrayChild = ((ObjectNode)parentNode).putArray(cleanedSegment);
            } else if (parentNode instanceof ArrayNode) {
                arrayChild = ((ArrayNode)parentNode).addArray();
            } else {
                throw new AtlasException(String.format("Unknown JsonNode type '%s' for segment '%s'", parentNode.getClass(), segment));
            }
            Integer index = segment.getCollectionIndex();
            if (index == null) {
                return null;
            }
            if (arrayChild.size() < index + 1) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Object Array is too small, resizing to accomodate index: " + index + ", current array: " + arrayChild);
                }
                while (arrayChild.size() < index + 1) {
                    arrayChild.addObject();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Object Array after resizing: " + arrayChild);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created wrapper parent array node '" + segment + "': " + arrayChild);
            }
            childNode = (ObjectNode)arrayChild.get(index.intValue());
        } else if (parentNode instanceof ObjectNode) {
            if (targetField.getStatus() != FieldStatus.NOT_FOUND) {
                childNode = ((ObjectNode)parentNode).putObject(cleanedSegment);
            }
        } else if (parentNode instanceof ArrayNode) {
            childNode = ((ArrayNode)parentNode).addObject();
        } else {
            throw new AtlasException(String.format("Unknown JsonNode type '%s' for segment '%s'", parentNode.getClass(), segment));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parent Node '" + parentSegment + "' after adding child parent node '" + segment + "':" + parentNode);
        }
        return childNode;
    }

    private JsonNode createValueNode(Field jsonField) {
        FieldType type = jsonField.getFieldType();
        Object value = jsonField.getValue();
        Object valueNode = null;
        valueNode = value == null ? this.rootNode.nullNode() : (FieldType.STRING.equals((Object)type) ? this.rootNode.textNode(String.valueOf(value)) : (FieldType.CHAR.equals((Object)type) ? this.rootNode.textNode(Character.toString(((Character)value).charValue())) : (FieldType.BOOLEAN.equals((Object)type) ? this.rootNode.booleanNode(((Boolean)value).booleanValue()) : (FieldType.INTEGER.equals((Object)type) ? this.rootNode.numberNode((Integer)value) : (FieldType.DOUBLE.equals((Object)type) || FieldType.FLOAT.equals((Object)type) || FieldType.NUMBER.equals((Object)type) ? this.rootNode.numberNode(new BigDecimal(String.valueOf(value))) : (FieldType.SHORT.equals((Object)type) ? this.rootNode.numberNode(Short.valueOf(String.valueOf(value))) : (FieldType.LONG.equals((Object)type) ? this.rootNode.numberNode(Long.valueOf(String.valueOf(value))) : (FieldType.BYTE.equals((Object)type) ? this.rootNode.numberNode(Byte.valueOf(String.valueOf(value))) : (FieldType.BIG_INTEGER.equals((Object)type) ? this.rootNode.numberNode(new BigInteger(String.valueOf(value))) : this.rootNode.textNode(String.valueOf(value)))))))))));
        if (LOG.isDebugEnabled()) {
            String valueClass = value == null ? "null" : value.getClass().getName();
            LOG.debug("Converted JsonField value to ValueNode. Type: " + (Object)((Object)type) + ", value: " + value + "(" + valueClass + "), node class: " + valueNode.getClass().getName() + ", node: " + valueNode);
        }
        return valueNode;
    }

    private JsonNode getChildNode(ContainerNode<?> parentNode, AtlasPath.SegmentContext parentSegment, AtlasPath.SegmentContext segment) {
        String cleanedSegment;
        JsonNode childNode;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Looking for child node '" + segment + "' in parent '" + parentSegment + "': " + parentNode);
        }
        if (JsonNodeType.MISSING.equals((Object)(childNode = parentNode.path(cleanedSegment = segment.getName())).getNodeType())) {
            childNode = null;
        }
        if (LOG.isDebugEnabled()) {
            if (childNode == null) {
                LOG.debug("Could not find child node '" + segment + "' in parent '" + parentSegment + "'.");
            } else {
                LOG.debug("Found child node '" + segment + "' in parent '" + parentSegment + "', class: " + childNode.getClass().getName() + ", node: " + childNode);
            }
        }
        return childNode;
    }
}

