/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.builder;

import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasMappingBuilder;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.builder.AtlasField;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.core.DefaultAtlasSession;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasFieldActionService;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.SimpleField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultAtlasMappingBuilder
implements AtlasMappingBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAtlasMappingBuilder.class);
    private DefaultAtlasSession session;
    private AtlasConversionService conversionService;
    private AtlasFieldActionService fieldActionService;

    public AtlasField read(String docId, String path) throws AtlasException {
        return new AtlasField(this.session).read(docId, path);
    }

    public AtlasField readConstant(String name) throws AtlasException {
        return new AtlasField(this.session).readConstant(name);
    }

    public AtlasField readProperty(String scope, String name) throws AtlasException {
        return new AtlasField(this.session).readProperty(scope, name);
    }

    public void write(String docId, String path, Object value) throws AtlasException {
        SimpleField source = new SimpleField();
        if (value != null) {
            source.setValue(value);
            source.setFieldType(this.conversionService.fieldTypeFromClass(value.getClass()));
        }
        new AtlasField(this.session).setRawField(source).write(docId, path);
    }

    @Override
    public void process() {
        try {
            this.processMapping();
        }
        catch (Exception e) {
            this.addAudit(e);
        }
    }

    public abstract void processMapping() throws Exception;

    @Override
    public void setAtlasSession(AtlasSession session) throws AtlasException {
        if (!(session instanceof DefaultAtlasSession)) {
            throw new IllegalArgumentException(String.format("This version of MappingBuilder doesn't support %s", session.getClass().getName()));
        }
        this.session = (DefaultAtlasSession)session;
        this.conversionService = session.getAtlasContext().getContextFactory().getConversionService();
        this.fieldActionService = session.getAtlasContext().getContextFactory().getFieldActionService();
    }

    public AtlasSession getAtlasSession() {
        return this.session;
    }

    public void addAudit(Exception e) {
        AtlasUtil.addAudit((AtlasInternalSession)this.session, this.getClass().getName(), e.getMessage(), AuditStatus.ERROR, null);
        if (LOG.isDebugEnabled()) {
            LOG.error("", (Throwable)e);
        }
    }
}

