/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasUnsupportedException;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.spi.AtlasConverter;
import io.atlasmap.v2.FieldType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;

public class IntegerConverter
implements AtlasConverter<Integer> {
    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.DECIMAL)
    public BigDecimal toBigDecimal(Integer value) {
        return value != null ? BigDecimal.valueOf(value.intValue()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.BIG_INTEGER)
    public BigInteger toBigInteger(Integer value) {
        return value != null ? BigInteger.valueOf(value.intValue()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.BOOLEAN, concerns={AtlasConversionConcern.CONVENTION})
    public Boolean toBoolean(Integer value) {
        if (value == null) {
            return null;
        }
        return value == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.BYTE, concerns={AtlasConversionConcern.RANGE})
    public Byte toByte(Integer value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value >= -128 && value <= 127) {
            return value.byteValue();
        }
        throw new AtlasConversionException(new AtlasUnsupportedException(String.format("Integer %s is greater than Byte.MAX_VALUE or less than Byte.MIN_VALUE", value)));
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.CHAR, concerns={AtlasConversionConcern.RANGE, AtlasConversionConcern.CONVENTION})
    public Character toCharacter(Integer value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value < 0 || value > 65535) {
            throw new AtlasConversionException(String.format("Integer %s is greater than Character.MAX_VALUE or less than Character.MIN_VALUE", value));
        }
        return Character.valueOf((char)value.intValue());
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.DATE_TIME)
    public Date toDate(Integer value) {
        if ((long)value.intValue() >= Instant.MIN.getEpochSecond()) {
            return Date.from(Instant.ofEpochMilli(value.intValue()));
        }
        return new Date(value.intValue());
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.DOUBLE)
    public Double toDouble(Integer value) {
        return value != null ? Double.valueOf(value.doubleValue()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.FLOAT, concerns={AtlasConversionConcern.RANGE})
    public Float toFloat(Integer value) {
        return value != null ? Float.valueOf(value.floatValue()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.INTEGER)
    public Integer toInteger(Integer value) {
        return value != null ? Integer.valueOf(value) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.DATE)
    public LocalDate toLocalDate(Integer value) {
        return value != null ? Instant.ofEpochMilli(value.intValue()).atZone(ZoneId.systemDefault()).toLocalDate() : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.TIME)
    public LocalTime toLocalTime(Integer value) {
        return value != null ? Instant.ofEpochMilli(value.intValue()).atZone(ZoneId.systemDefault()).toLocalTime() : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.DATE_TIME)
    public LocalDateTime toLocalDateTime(Integer value) {
        return value != null ? Instant.ofEpochMilli(value.intValue()).atZone(ZoneId.systemDefault()).toLocalDateTime() : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.LONG)
    public Long toLong(Integer value) {
        return value != null ? Long.valueOf(value.longValue()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.SHORT, concerns={AtlasConversionConcern.RANGE})
    public Short toShort(Integer value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value > Short.MAX_VALUE || value < Short.MIN_VALUE) {
            throw new AtlasConversionException(String.format("Integer %s is greater than Short.MAX_VALUE or less than Short.MIN_VALUE", value));
        }
        return value.shortValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.STRING)
    public String toString(Integer value) {
        return value != null ? String.valueOf(value) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.STRING)
    public CharBuffer toCharBuffer(Integer value) {
        return value != null ? CharBuffer.wrap(this.toString(value)) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.STRING)
    public CharSequence toCharSequence(Integer value) {
        return value != null ? this.toString(value) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.STRING)
    public StringBuffer toStringBuffer(Integer value) {
        return value != null ? new StringBuffer(this.toString(value)) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.STRING)
    public StringBuilder toStringBuilder(Integer value) {
        return value != null ? new StringBuilder(this.toString(value)) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.NUMBER)
    public Number toNumber(Integer value) {
        return value;
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.DATE_TIME_TZ)
    public ZonedDateTime toZonedDateTime(Integer value) {
        return value != null ? Instant.ofEpochMilli(value.intValue()).atZone(ZoneId.systemDefault()) : null;
    }
}

