/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.core.DefaultAtlasFieldActionService;
import io.atlasmap.expression.Expression;
import io.atlasmap.expression.FunctionResolver;
import io.atlasmap.expression.parser.ParseException;
import io.atlasmap.spi.ActionProcessor;
import io.atlasmap.spi.FunctionFactory;
import io.atlasmap.v2.ActionParameter;
import io.atlasmap.v2.ActionParameters;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ServiceLoader;

public class DefaultAtlasFunctionResolver
implements FunctionResolver {
    private static DefaultAtlasFunctionResolver instance;
    private HashMap<String, FunctionFactory> functions = new HashMap();
    private DefaultAtlasFieldActionService fieldActionService;

    public static DefaultAtlasFunctionResolver getInstance() {
        if (instance == null) {
            instance = new DefaultAtlasFunctionResolver();
            instance.init();
        }
        return instance;
    }

    private void init() {
        this.functions = new HashMap();
        ServiceLoader<FunctionFactory> implementations = ServiceLoader.load(FunctionFactory.class, FunctionFactory.class.getClassLoader());
        for (FunctionFactory f : implementations) {
            this.functions.put(f.getName().toUpperCase(), f);
        }
        this.fieldActionService = DefaultAtlasFieldActionService.getInstance();
        this.fieldActionService.init();
    }

    @Override
    public Expression resolve(String name, List<Expression> args) throws ParseException {
        String functionName = name.toUpperCase();
        FunctionFactory f = this.functions.get(functionName);
        if (f != null) {
            return f.create(args);
        }
        return ctx -> {
            ArrayList<Field> arguments = new ArrayList<Field>();
            for (Expression arg : args) {
                arguments.add(arg.evaluate(ctx));
            }
            Object valueForTypeEvaluation = null;
            if (arguments.isEmpty()) {
                return null;
            }
            valueForTypeEvaluation = arguments.get(arguments.size() - 1);
            ActionProcessor actionProcessor = this.fieldActionService.findActionProcessor(name, valueForTypeEvaluation);
            if (actionProcessor != null) {
                HashMap<String, Object> actionParameters = new HashMap<String, Object>();
                ActionParameters actionDetailParameters = actionProcessor.getActionDetail().getParameters();
                if (actionDetailParameters != null && actionDetailParameters.getParameter() != null) {
                    for (ActionParameter parameter : actionDetailParameters.getParameter()) {
                        if (!arguments.isEmpty()) {
                            Object parameterValue = ((Field)arguments.remove(0)).getValue();
                            actionParameters.put(parameter.getName(), parameterValue);
                            continue;
                        }
                        throw new IllegalArgumentException(String.format("The transformation '%s' expects more parameters. The parameter '%s' is missing", name, parameter.getName()));
                    }
                }
                if (arguments.isEmpty()) {
                    throw new IllegalArgumentException(String.format("The transformation '%s' expects more arguments", name));
                }
                FieldGroup fields = new FieldGroup();
                fields.getField().addAll(arguments);
                return this.fieldActionService.buildAndProcessAction(actionProcessor, actionParameters, fields);
            }
            throw new IllegalArgumentException(String.format("The expression function or transformation '%s' was not found", name));
        };
    }
}

