/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.spi.AtlasModuleInfo;
import io.atlasmap.spi.AtlasModuleInfoRegistry;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAtlasModuleInfoRegistry
implements AtlasModuleInfoRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAtlasModuleInfoRegistry.class);
    private final String jmxObjectNamePrefix;
    private final Set<AtlasModuleInfo> moduleInfos = new HashSet<AtlasModuleInfo>();

    public DefaultAtlasModuleInfoRegistry(DefaultAtlasContextFactory factory) {
        this.jmxObjectNamePrefix = factory.getJmxObjectName() + ",modules=AvailableModules,moduleName=";
    }

    @Override
    public AtlasModuleInfo lookupByUri(String uri) {
        if (uri == null) {
            return null;
        }
        for (AtlasModuleInfo module : this.moduleInfos) {
            if (!uri.startsWith(module.getUri())) continue;
            return module;
        }
        return null;
    }

    @Override
    public Set<AtlasModuleInfo> getAll() {
        return Collections.unmodifiableSet(this.moduleInfos);
    }

    @Override
    public void register(AtlasModuleInfo module) {
        this.moduleInfos.add(module);
        this.registerModuleJmx(module);
    }

    @Override
    public int size() {
        return this.moduleInfos.size();
    }

    @Override
    public synchronized void unregisterAll() {
        for (AtlasModuleInfo info : this.moduleInfos) {
            this.unregisterModuleJmx(info);
        }
        this.moduleInfos.clear();
    }

    private void registerModuleJmx(AtlasModuleInfo module) {
        try {
            String n = this.jmxObjectNamePrefix + module.getName();
            ObjectName on = new ObjectName(n);
            if (!ManagementFactory.getPlatformMBeanServer().isRegistered(on)) {
                ManagementFactory.getPlatformMBeanServer().registerMBean(module, on);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Registered AtlasModule '" + module.getName() + "' with JMX");
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to register AtlasModule '" + module.getName() + "' with JMX", (Throwable)e);
        }
    }

    private void unregisterModuleJmx(AtlasModuleInfo module) {
        try {
            String n = this.jmxObjectNamePrefix + module.getName();
            ObjectName on = new ObjectName(n);
            if (ManagementFactory.getPlatformMBeanServer().isRegistered(on)) {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(on);
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to unregister module '" + module.getName() + "' from JMX");
        }
    }
}

