/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasException;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.core.ConstantModule;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.PropertyModule;
import io.atlasmap.spi.AtlasFieldReader;
import io.atlasmap.spi.AtlasFieldWriter;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.spi.AtlasModule;
import io.atlasmap.spi.AtlasPropertyStrategy;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.Audit;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.Audits;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.LookupTable;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.Validations;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultAtlasSession
implements AtlasInternalSession {
    private DefaultAtlasContext atlasContext;
    private final AtlasMapping mapping;
    private Audits audits;
    private Validations validations;
    private Map<String, Object> sourceProperties;
    private Map<String, Object> targetProperties;
    private AtlasPropertyStrategy propertyStrategy;
    private Map<String, Object> sourceMap;
    private Map<String, Object> targetMap;
    private Map<String, AtlasFieldReader> fieldReaderMap;
    private Map<String, AtlasFieldWriter> fieldWriterMap;
    private AtlasInternalSession.Head head = new HeadImpl(this);
    private String defaultSourceDocumentId;
    private String defaultTargetDocumentId;

    public DefaultAtlasSession(DefaultAtlasContext context) throws AtlasException {
        this.atlasContext = context;
        this.initialize();
        if (context.getMapping() == null) {
            this.mapping = null;
            return;
        }
        this.mapping = context.getADMArchiveHandler().cloneMappingDefinition();
    }

    protected void initialize() {
        this.sourceProperties = new ConcurrentHashMap<String, Object>();
        this.targetProperties = new ConcurrentHashMap<String, Object>();
        this.validations = new Validations();
        this.audits = new Audits();
        this.sourceMap = new HashMap<String, Object>();
        this.targetMap = new HashMap<String, Object>();
        this.fieldReaderMap = new HashMap<String, AtlasFieldReader>();
        this.fieldWriterMap = new HashMap<String, AtlasFieldWriter>();
        this.head.unset();
    }

    @Override
    public DefaultAtlasContext getAtlasContext() {
        return this.atlasContext;
    }

    @Override
    public void setAtlasContext(AtlasContext atlasContext) {
        this.atlasContext = (DefaultAtlasContext)atlasContext;
        this.head.unset();
    }

    @Override
    public AtlasMapping getMapping() {
        return this.mapping;
    }

    @Override
    public Validations getValidations() {
        return this.validations;
    }

    @Override
    public void setValidations(Validations validations) {
        this.validations = validations;
    }

    @Override
    public Audits getAudits() {
        return this.audits;
    }

    @Override
    public void setAudits(Audits audits) {
        this.audits = audits;
    }

    @Override
    public Object getDefaultSourceDocument() {
        return this.sourceMap.get(this.getDefaultSourceDocumentId());
    }

    private String getDefaultSourceDocumentId() {
        if (this.defaultSourceDocumentId == null) {
            Optional<String> found = this.atlasContext.getSourceModules().keySet().stream().filter(key -> !"ATLAS_CONSTANTS_DOC".equals(key) && !"ATLAS_SOURCE_PROPERTIES_DOC".equals(key)).findFirst();
            this.defaultSourceDocumentId = found.isPresent() ? found.get() : "ATLAS_DEFAULT_SOURCE_DOC";
        }
        return this.defaultSourceDocumentId;
    }

    @Override
    public Object getSourceDocument(String docId) {
        if (docId == null || docId.isEmpty()) {
            return this.getDefaultSourceDocument();
        }
        if (this.sourceMap.containsKey(docId)) {
            return this.sourceMap.get(docId);
        }
        if (this.sourceMap.size() == 1 && this.sourceMap.containsKey("ATLAS_DEFAULT_SOURCE_DOC")) {
            AtlasUtil.addAudit((AtlasInternalSession)this, docId, String.format("There's no source document with docId='%s', returning default", docId), AuditStatus.WARN, null);
            return this.getDefaultSourceDocument();
        }
        AtlasUtil.addAudit((AtlasInternalSession)this, docId, String.format("There's no source document with docId='%s'", docId), AuditStatus.WARN, null);
        return null;
    }

    @Override
    public boolean hasSourceDocument(String docId) {
        if (docId == null || docId.isEmpty()) {
            return this.sourceMap.containsKey("ATLAS_DEFAULT_SOURCE_DOC");
        }
        return this.sourceMap.containsKey(docId);
    }

    @Override
    public Map<String, Object> getSourceDocumentMap() {
        return Collections.unmodifiableMap(this.sourceMap);
    }

    @Override
    public Object getDefaultTargetDocument() {
        return this.targetMap.get(this.getDefaultTargetDocumentId());
    }

    private String getDefaultTargetDocumentId() {
        if (this.defaultTargetDocumentId == null) {
            Optional<String> found = this.atlasContext.getTargetModules().keySet().stream().filter(key -> !"ATLAS_TARGET_PROPERTIES_DOC".equals(key)).findFirst();
            this.defaultTargetDocumentId = found.isPresent() ? found.get() : "ATLAS_DEFAULT_TARGET_DOC";
        }
        return this.defaultTargetDocumentId;
    }

    @Override
    public Object getTargetDocument(String docId) {
        if (docId == null || docId.isEmpty()) {
            return this.getDefaultTargetDocument();
        }
        if (this.targetMap.containsKey(docId)) {
            return this.targetMap.get(docId);
        }
        if (this.targetMap.size() == 1 && this.targetMap.containsKey("ATLAS_DEFAULT_TARGET_DOC")) {
            AtlasUtil.addAudit((AtlasInternalSession)this, docId, String.format("There's no target document with docId='%s', returning default", docId), AuditStatus.WARN, null);
            return this.getDefaultTargetDocument();
        }
        AtlasUtil.addAudit((AtlasInternalSession)this, docId, String.format("There's no target document with docId='%s'", docId), AuditStatus.WARN, null);
        return null;
    }

    @Override
    public boolean hasTargetDocument(String docId) {
        if (docId == null || docId.isEmpty()) {
            return this.targetMap.containsKey("ATLAS_DEFAULT_TARGET_DOC");
        }
        return this.targetMap.containsKey(docId);
    }

    @Override
    public Map<String, Object> getTargetDocumentMap() {
        return Collections.unmodifiableMap(this.targetMap);
    }

    @Override
    public void setDefaultSourceDocument(Object sourceDoc) {
        this.sourceMap.put(this.getDefaultSourceDocumentId(), sourceDoc);
    }

    @Override
    public void setSourceDocument(String docId, Object sourceDoc) {
        if (docId == null || docId.isEmpty()) {
            this.setDefaultSourceDocument(sourceDoc);
        } else {
            if (this.sourceMap.isEmpty()) {
                this.setDefaultSourceDocument(sourceDoc);
            }
            this.sourceMap.put(docId, sourceDoc);
        }
    }

    @Override
    public void setDefaultTargetDocument(Object targetDoc) {
        this.targetMap.put(this.getDefaultTargetDocumentId(), targetDoc);
    }

    @Override
    public void setTargetDocument(String docId, Object targetDoc) {
        if (docId == null || docId.isEmpty()) {
            this.setDefaultTargetDocument(targetDoc);
        } else {
            if (this.targetMap.isEmpty()) {
                this.setDefaultTargetDocument(targetDoc);
            }
            this.targetMap.put(docId, targetDoc);
        }
    }

    @Override
    public AtlasFieldReader getFieldReader(String docId) {
        if (docId == null || docId.isEmpty()) {
            return this.fieldReaderMap.get("ATLAS_DEFAULT_SOURCE_DOC");
        }
        return this.fieldReaderMap.get(docId);
    }

    @Override
    public <T extends AtlasFieldReader> T getFieldReader(String docId, Class<T> clazz) {
        return (T)((AtlasFieldReader)clazz.cast(this.getFieldReader(docId)));
    }

    @Override
    public void setFieldReader(String docId, AtlasFieldReader reader) {
        if (docId == null || docId.isEmpty()) {
            this.fieldReaderMap.put("ATLAS_DEFAULT_SOURCE_DOC", reader);
        } else {
            this.fieldReaderMap.put(docId, reader);
        }
    }

    @Override
    public AtlasFieldReader removeFieldReader(String docId) {
        if (docId == null || docId.isEmpty()) {
            return this.fieldReaderMap.remove("ATLAS_DEFAULT_SOURCE_DOC");
        }
        return this.fieldReaderMap.remove(docId);
    }

    @Override
    public AtlasFieldWriter getFieldWriter(String docId) {
        if (docId == null || docId.isEmpty()) {
            return this.fieldWriterMap.get("ATLAS_DEFAULT_TARGET_DOC");
        }
        return this.fieldWriterMap.get(docId);
    }

    @Override
    public <T extends AtlasFieldWriter> T getFieldWriter(String docId, Class<T> clazz) {
        return (T)((AtlasFieldWriter)clazz.cast(this.getFieldWriter(docId)));
    }

    @Override
    public void setFieldWriter(String docId, AtlasFieldWriter writer) {
        if (docId == null || docId.isEmpty()) {
            this.fieldWriterMap.put("ATLAS_DEFAULT_TARGET_DOC", writer);
        }
        this.fieldWriterMap.put(docId, writer);
    }

    @Override
    public AtlasFieldWriter removeFieldWriter(String docId) {
        if (docId == null || docId.isEmpty()) {
            return this.fieldWriterMap.remove("ATLAS_DEFAULT_TARGET_DOC");
        }
        return this.fieldWriterMap.remove(docId);
    }

    @Override
    public AtlasInternalSession.Head head() {
        return this.head;
    }

    @Override
    @Deprecated
    public Map<String, Object> getProperties() {
        return this.getSourceProperties();
    }

    @Override
    public Map<String, Object> getSourceProperties() {
        return this.sourceProperties;
    }

    @Override
    public Map<String, Object> getTargetProperties() {
        return this.targetProperties;
    }

    @Override
    public AtlasPropertyStrategy getAtlasPropertyStrategy() {
        return this.propertyStrategy;
    }

    @Override
    public void setAtlasPropertyStrategy(AtlasPropertyStrategy strategy) {
        this.propertyStrategy = strategy;
    }

    @Override
    public Integer errorCount() {
        int e = 0;
        for (Audit audit : this.getAudits().getAudit()) {
            if (!AuditStatus.ERROR.equals((Object)audit.getStatus())) continue;
            ++e;
        }
        return e;
    }

    @Override
    public boolean hasErrors() {
        for (Audit audit : this.getAudits().getAudit()) {
            if (!AuditStatus.ERROR.equals((Object)audit.getStatus())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasWarns() {
        for (Audit audit : this.getAudits().getAudit()) {
            if (!AuditStatus.WARN.equals((Object)audit.getStatus())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Integer warnCount() {
        int w = 0;
        for (Audit audit : this.getAudits().getAudit()) {
            if (!AuditStatus.WARN.equals((Object)audit.getStatus())) continue;
            ++w;
        }
        return w;
    }

    @Override
    public AtlasModule resolveModule(String docId) {
        AtlasModule answer = this.getAtlasContext().getSourceModules().get(docId);
        if (answer == null) {
            answer = this.getAtlasContext().getTargetModules().get(docId);
        }
        return answer;
    }

    public ConstantModule getConstantModule() {
        return (ConstantModule)this.getAtlasContext().getSourceModules().get("ATLAS_CONSTANTS_DOC");
    }

    public PropertyModule getSourcePropertyModule() {
        return (PropertyModule)this.getAtlasContext().getSourceModules().get("ATLAS_SOURCE_PROPERTIES_DOC");
    }

    public PropertyModule getTargetPropertyModule() {
        return (PropertyModule)this.getAtlasContext().getTargetModules().get("ATLAS_TARGET_PROPERTIES_DOC");
    }

    private class HeadImpl
    implements AtlasInternalSession.Head {
        private DefaultAtlasSession session;
        private Mapping mapping;
        private LookupTable lookupTable;
        private Field sourceField;
        private Field targetField;
        private List<Audit> audits = new LinkedList<Audit>();

        public HeadImpl(DefaultAtlasSession session) {
            this.session = session;
        }

        @Override
        public Mapping getMapping() {
            return this.mapping;
        }

        @Override
        public LookupTable getLookupTable() {
            return this.lookupTable;
        }

        @Override
        public Field getSourceField() {
            return this.sourceField;
        }

        @Override
        public Field getTargetField() {
            return this.targetField;
        }

        @Override
        public AtlasInternalSession.Head setMapping(Mapping mapping) {
            this.mapping = mapping;
            return this;
        }

        @Override
        public AtlasInternalSession.Head setLookupTable(LookupTable table) {
            this.lookupTable = table;
            return this;
        }

        @Override
        public AtlasInternalSession.Head setSourceField(Field sourceField) {
            this.sourceField = sourceField;
            return this;
        }

        @Override
        public AtlasInternalSession.Head setTargetField(Field targetField) {
            this.targetField = targetField;
            return this;
        }

        @Override
        public AtlasInternalSession.Head unset() {
            this.mapping = null;
            this.lookupTable = null;
            this.sourceField = null;
            this.targetField = null;
            return this;
        }

        @Override
        public boolean hasError() {
            for (Audit audit : this.audits) {
                if (audit.getStatus() != AuditStatus.ERROR) continue;
                return true;
            }
            return false;
        }

        @Override
        public AtlasInternalSession.Head addAudit(AuditStatus status, Field field, String message) {
            String docId = field != null ? field.getDocId() : null;
            String docName = AtlasUtil.getDocumentNameById(this.session, docId);
            String path = field != null ? field.getPath() : null;
            Audit audit = AtlasUtil.createAudit(status, docId, docName, path, null, message);
            this.audits.add(audit);
            return this;
        }

        @Override
        public List<Audit> getAudits() {
            return this.audits;
        }
    }
}

