/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.csv.core;

import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvConfig {
    private static final Logger LOG = LoggerFactory.getLogger(CsvConfig.class);
    private String format;
    private Character delimiter;
    private Boolean firstRecordAsHeader;
    private Boolean skipHeaderRecord;
    private String headers;
    private Character commentMarker;
    private Character escape;
    private Boolean ignoreEmptyLines;
    private Boolean ignoreHeaderCase;
    private Boolean ignoreSurroundingSpaces;
    private String nullString;
    private Character quote;
    private Boolean allowDuplicateHeaderNames;
    private Boolean allowMissingColumnNames;

    public CsvConfig() {
        this(null);
    }

    public CsvConfig(String format) {
        this.format = format == null ? "Default" : format;
        this.delimiter = Character.valueOf(CSVFormat.valueOf((String)this.format).getDelimiter());
    }

    public static CsvConfig newConfig(Map<String, String> config) {
        CsvConfig csvConfig = new CsvConfig(config.get("format"));
        String delimiter = config.get("delimiter");
        for (Map.Entry<String, String> entry : config.entrySet()) {
            switch (entry.getKey()) {
                case "delimiter": {
                    csvConfig.delimiter = Character.valueOf(delimiter.charAt(0));
                    break;
                }
                case "firstRecordAsHeader": {
                    csvConfig.firstRecordAsHeader = entry.getValue() == null || Boolean.valueOf(entry.getValue()) != false;
                    break;
                }
                case "skipHeaderRecord": {
                    csvConfig.skipHeaderRecord = entry.getValue() == null || Boolean.valueOf(entry.getValue()) != false;
                    break;
                }
                case "commentMarker": {
                    csvConfig.commentMarker = Character.valueOf(entry.getValue().charAt(0));
                    break;
                }
                case "headers": {
                    csvConfig.headers = entry.getValue();
                    break;
                }
                case "escape": {
                    csvConfig.escape = Character.valueOf(entry.getValue().charAt(0));
                    break;
                }
                case "ignoreEmptyLines": {
                    csvConfig.ignoreEmptyLines = entry.getValue() == null || Boolean.valueOf(entry.getValue()) != false;
                    break;
                }
                case "ignoreHeaderCase": {
                    csvConfig.ignoreHeaderCase = entry.getValue() == null || Boolean.valueOf(entry.getValue()) != false;
                    break;
                }
                case "ignoreSurroundingSpaces": {
                    csvConfig.ignoreSurroundingSpaces = entry.getValue() == null || Boolean.valueOf(entry.getValue()) != false;
                    break;
                }
                case "nullString": {
                    csvConfig.nullString = entry.getValue();
                    break;
                }
                case "quote": {
                    csvConfig.quote = Character.valueOf(entry.getValue().charAt(0));
                    break;
                }
                case "allowDuplicateHeaderNames": {
                    csvConfig.allowDuplicateHeaderNames = entry.getValue() == null || Boolean.valueOf(entry.getValue()) != false;
                    break;
                }
                case "allowMissingColumnNames": {
                    csvConfig.allowMissingColumnNames = entry.getValue() == null || Boolean.valueOf(entry.getValue()) != false;
                }
            }
        }
        return csvConfig;
    }

    CSVFormat newCsvFormat() {
        CSVFormat csvFormat = this.format != null ? CSVFormat.valueOf((String)this.format) : CSVFormat.DEFAULT;
        csvFormat = this.delimiter != null ? csvFormat.withDelimiter(this.delimiter.charValue()) : csvFormat;
        csvFormat = Boolean.TRUE.equals(this.firstRecordAsHeader) ? csvFormat.withFirstRecordAsHeader() : csvFormat;
        csvFormat = this.skipHeaderRecord != null ? csvFormat.withSkipHeaderRecord(this.skipHeaderRecord.booleanValue()) : csvFormat;
        csvFormat = this.headers != null ? csvFormat.withHeader(this.getParsedHeaders()) : csvFormat;
        csvFormat = this.commentMarker != null ? csvFormat.withCommentMarker(this.commentMarker) : csvFormat;
        csvFormat = this.escape != null ? csvFormat.withEscape(this.escape) : csvFormat;
        csvFormat = this.ignoreEmptyLines != null ? csvFormat.withIgnoreEmptyLines(this.ignoreEmptyLines.booleanValue()) : csvFormat;
        csvFormat = this.ignoreHeaderCase != null ? csvFormat.withIgnoreHeaderCase(this.ignoreHeaderCase.booleanValue()) : csvFormat;
        csvFormat = this.ignoreSurroundingSpaces != null ? csvFormat.withIgnoreSurroundingSpaces(this.ignoreSurroundingSpaces.booleanValue()) : csvFormat;
        csvFormat = this.nullString != null ? csvFormat.withNullString(this.nullString) : csvFormat;
        csvFormat = this.quote != null ? csvFormat.withQuote(this.quote) : csvFormat;
        csvFormat = this.allowDuplicateHeaderNames != null ? csvFormat.withAllowDuplicateHeaderNames(this.allowDuplicateHeaderNames.booleanValue()) : csvFormat;
        csvFormat = this.allowMissingColumnNames != null ? csvFormat.withAllowMissingColumnNames(this.allowMissingColumnNames.booleanValue()) : csvFormat;
        return csvFormat;
    }

    public String getFormat() {
        return this.format;
    }

    public void setDelimiter(Character delimiter) {
        this.delimiter = delimiter;
    }

    public char getDelimiter() {
        return this.delimiter.charValue();
    }

    public void setFirstRecordAsHeader(Boolean firstRecordAsHeader) {
        this.firstRecordAsHeader = firstRecordAsHeader;
    }

    public boolean isFirstRecordAsHeader() {
        return Boolean.TRUE.equals(this.firstRecordAsHeader);
    }

    public Boolean getFirstRecordAsHeader() {
        return this.firstRecordAsHeader;
    }

    public void setSkipHeaderRecord(Boolean skipHeaderRecord) {
        this.skipHeaderRecord = skipHeaderRecord;
    }

    public Boolean getSkipHeaderRecord() {
        return this.skipHeaderRecord;
    }

    public void setHeaders(String headers) {
        this.headers = headers;
    }

    public String getHeaders() {
        return this.headers;
    }

    public String[] getParsedHeaders() {
        return this.headers != null ? this.headers.split(this.delimiter.toString()) : null;
    }

    public void setCommentMarker(Character commentMarker) {
        this.commentMarker = commentMarker;
    }

    public Character getCommentMarker() {
        return this.commentMarker;
    }

    public Character getEscape() {
        return this.escape;
    }

    public void setEscape(Character escape) {
        this.escape = escape;
    }

    public Boolean getIgnoreEmptyLines() {
        return this.ignoreEmptyLines;
    }

    public void setIgnoreEmptyLines(Boolean ignoreEmptyLines) {
        this.ignoreEmptyLines = ignoreEmptyLines;
    }

    public Boolean getIgnoreHeaderCase() {
        return this.ignoreHeaderCase;
    }

    public void setIgnoreHeaderCase(Boolean ignoreHeaderCase) {
        this.ignoreHeaderCase = ignoreHeaderCase;
    }

    public Boolean getIgnoreSurroundingSpaces() {
        return this.ignoreSurroundingSpaces;
    }

    public void setIgnoreSurroundingSpaces(Boolean ignoreSurroundingSpaces) {
        this.ignoreSurroundingSpaces = ignoreSurroundingSpaces;
    }

    public String getNullString() {
        return this.nullString;
    }

    public void setNullString(String nullString) {
        this.nullString = nullString;
    }

    public Character getQuote() {
        return this.quote;
    }

    public void setQuote(Character quote) {
        this.quote = quote;
    }

    public Boolean getAllowDuplicateHeaderNames() {
        return this.allowDuplicateHeaderNames;
    }

    public void setAllowDuplicateHeaderNames(Boolean allowDuplicateHeaderNames) {
        this.allowDuplicateHeaderNames = allowDuplicateHeaderNames;
    }

    public Boolean getAllowMissingColumnNames() {
        return this.allowMissingColumnNames;
    }

    public void setAllowMissingColumnNames(Boolean allowMissingColumnNames) {
        this.allowMissingColumnNames = allowMissingColumnNames;
    }
}

