/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.java.core;

import io.atlasmap.core.AtlasUtil;
import io.atlasmap.java.core.StringUtil;
import io.atlasmap.java.core.accessor.FieldAccessor;
import io.atlasmap.java.core.accessor.GetterAccessor;
import io.atlasmap.java.core.accessor.JavaChildAccessor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ClassHelper {
    public static List<String> getterMethodNames(String fieldName) {
        ArrayList<String> opts = new ArrayList<String>();
        opts.add(ClassHelper.getMethodNameFromFieldName(fieldName));
        opts.add(ClassHelper.isMethodNameFromFieldName(fieldName));
        return opts;
    }

    public static String getMethodNameFromFieldName(String fieldName) {
        return "get" + StringUtil.capitalizeFirstLetter(fieldName);
    }

    public static String isMethodNameFromFieldName(String fieldName) {
        return "is" + StringUtil.capitalizeFirstLetter(fieldName);
    }

    public static Method detectGetterMethod(Class<?> clazz, String methodName) throws NoSuchMethodException {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            if (!method.getName().equals(methodName) || method.getParameterCount() != 0) continue;
            return method;
        }
        throw new NoSuchMethodException(String.format("No matching getter method for class=%s method=%s", clazz.getName(), methodName));
    }

    public static Map<String, Method> detectAllGetterMethods(Class<?> clazz) throws Exception {
        Method[] methods;
        HashMap<String, Method> answer = new HashMap<String, Method>();
        for (Method method : methods = clazz.getMethods()) {
            if (method.getName().startsWith("get") && method.getParameterTypes().length == 0 && method.getReturnType() != Void.class) {
                answer.put(StringUtil.getFieldNameFromGetter(method.getName()), method);
                continue;
            }
            if (!method.getName().startsWith("is") || method.getParameterTypes().length != 0 || method.getReturnType() != Boolean.TYPE && method.getReturnType() != Boolean.class) continue;
            answer.put(StringUtil.getFieldNameFromGetter(method.getName()), method);
        }
        return answer;
    }

    public static List<Field> detectAllJavaFields(Class<?> clazz) {
        ArrayList<Field> answer = new ArrayList<Field>();
        Class<?> targetClazz = clazz;
        while (targetClazz != null && targetClazz != Object.class) {
            try {
                Field[] fields = targetClazz.getDeclaredFields();
                answer.addAll(Arrays.asList(fields));
            }
            catch (Exception e) {
                e.getMessage();
                targetClazz = targetClazz.getSuperclass();
            }
        }
        return answer;
    }

    public static Method detectSetterMethod(Class<?> clazz, String methodName, Class<?> paramType) throws NoSuchMethodException {
        String paramTypeClassName;
        Method[] methods;
        ArrayList<Method> candidates = new ArrayList<Method>();
        for (Method method : methods = clazz.getMethods()) {
            if (!method.getName().equals(methodName) || method.getParameterCount() != 1) continue;
            candidates.add(method);
        }
        String string = paramTypeClassName = paramType == null ? null : paramType.getName();
        if (candidates.size() == 0) {
            throw new NoSuchMethodException(String.format("No matching setter found for class=%s method=%s paramType=%s", clazz.getName(), methodName, paramTypeClassName));
        }
        if (paramType != null) {
            for (Method candidate : candidates) {
                if (!candidate.getParameterTypes()[0].isAssignableFrom(paramType)) continue;
                return candidate;
            }
            throw new NoSuchMethodException(String.format("No matching setter found for class=%s method=%s paramType=%s", clazz.getName(), methodName, paramTypeClassName));
        }
        if (candidates.size() == 1) {
            return (Method)candidates.get(0);
        }
        Method getter = null;
        Class<?> returnType = null;
        for (String prefix : Arrays.asList("get", "is")) {
            try {
                getter = ClassHelper.detectGetterMethod(clazz, methodName.replace("set", prefix));
                returnType = getter.getReturnType();
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        for (Method candidate : candidates) {
            Class<?> candidateReturnType = candidate.getParameterTypes()[0];
            if (!(returnType == null ? candidateReturnType == null : returnType.isAssignableFrom(candidateReturnType))) continue;
            return candidate;
        }
        throw new NoSuchMethodException(String.format("Unable to auto-detect setter class=%s method=%s paramType=%s", clazz.getName(), methodName, paramTypeClassName));
    }

    public static Class<?> detectClassFromTypeArgument(Type type) {
        return ClassHelper.detectClassFromTypeArgumentAt(type, 0);
    }

    public static Class<?> detectClassFromTypeArgumentAt(Type type, int pos) {
        if (type == null || !(type instanceof ParameterizedType)) {
            return Object.class;
        }
        ParameterizedType genericType = (ParameterizedType)type;
        Type[] typeArgs = genericType.getActualTypeArguments();
        if (typeArgs == null || typeArgs.length <= pos) {
            return Object.class;
        }
        return typeArgs[pos] instanceof Class ? (Class)typeArgs[pos] : Object.class;
    }

    public static Method lookupGetterMethod(Object object, String name) {
        List<String> getters = ClassHelper.getterMethodNames(name);
        Method getterMethod = null;
        for (String getter : getters) {
            try {
                getterMethod = ClassHelper.detectGetterMethod(object.getClass(), getter);
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        if (getterMethod == null) {
            return null;
        }
        getterMethod.setAccessible(true);
        return getterMethod;
    }

    public static Field lookupJavaField(Object source, String fieldName) {
        Class<?> targetClazz;
        Class<?> clazz = targetClazz = source != null ? source.getClass() : null;
        while (targetClazz != null && targetClazz != Object.class) {
            try {
                Field field = targetClazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (Exception e) {
                e.getMessage();
                targetClazz = targetClazz.getSuperclass();
            }
        }
        return null;
    }

    public static JavaChildAccessor lookupAccessor(Object source, String name) {
        if (source == null || AtlasUtil.isEmpty(name)) {
            return null;
        }
        Method m = ClassHelper.lookupGetterMethod(source, name);
        if (m != null) {
            return new GetterAccessor(source, name, m);
        }
        Field f = ClassHelper.lookupJavaField(source, name);
        if (f != null) {
            return new FieldAccessor(source, name, f);
        }
        return null;
    }

    public static List<JavaChildAccessor> lookupAllAccessors(Object source) throws Exception {
        ArrayList<JavaChildAccessor> answer = new ArrayList<JavaChildAccessor>();
        if (source == null) {
            return answer;
        }
        HashSet names = new HashSet();
        Map<String, Method> getters = ClassHelper.detectAllGetterMethods(source.getClass());
        getters.forEach((k, v) -> {
            answer.add(new GetterAccessor(source, (String)k, (Method)v));
            names.add(k);
        });
        List<Field> fields = ClassHelper.detectAllJavaFields(source.getClass());
        fields.forEach(f -> {
            if (!names.contains(f.getName())) {
                answer.add(new FieldAccessor(source, f.getName(), (Field)f));
            }
        });
        return answer;
    }
}

