/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.java.core;

import io.atlasmap.api.AtlasException;
import io.atlasmap.core.AtlasPath;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.java.core.JavaFieldWriterUtil;
import io.atlasmap.java.v2.JavaEnumField;
import io.atlasmap.java.v2.JavaField;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.LookupEntry;
import io.atlasmap.v2.LookupTable;
import java.lang.reflect.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetValueConverter {
    private static final Logger LOG = LoggerFactory.getLogger(TargetValueConverter.class);
    private AtlasConversionService conversionService = null;
    private JavaFieldWriterUtil writerUtil = null;
    private ClassLoader classLoader;

    public TargetValueConverter(ClassLoader loader, AtlasConversionService conversionService, JavaFieldWriterUtil writerUtil) {
        this.classLoader = loader;
        this.conversionService = conversionService;
        this.writerUtil = writerUtil;
    }

    public void populateTargetField(AtlasInternalSession session, LookupTable lookupTable, Field sourceField, Object parentObject, Field targetField) throws AtlasException {
        if (sourceField == null) {
            AtlasUtil.addAudit(session, (String)null, "Source field cannot be null", AuditStatus.ERROR, null);
            return;
        }
        if (targetField == null) {
            AtlasUtil.addAudit(session, (String)null, "Target field cannot be null", AuditStatus.ERROR, null);
            return;
        }
        Object sourceValue = sourceField.getValue();
        if (LOG.isDebugEnabled()) {
            LOG.debug("processTargetMapping srcPath={} srcVal={} srcType={}  tgtPath={} tgtdocId={}", new Object[]{sourceField.getPath(), sourceField.getValue(), sourceField.getFieldType(), targetField.getPath(), targetField.getDocId()});
        }
        String targetClassName = targetField instanceof JavaField ? ((JavaField)targetField).getClassName() : null;
        String string = targetClassName = targetField instanceof JavaEnumField ? ((JavaEnumField)targetField).getClassName() : targetClassName;
        if (targetClassName == null && parentObject != null) {
            Class<?> clazz;
            AtlasPath.SegmentContext segment = new AtlasPath(targetField.getPath()).getLastSegment();
            Class<?> clazz2 = clazz = segment.getCollectionType() == CollectionType.NONE ? this.writerUtil.resolveChildClass(parentObject, segment) : this.writerUtil.resolveCollectionItemClass(parentObject, segment);
            if (targetField.getFieldType() == null) {
                targetField.setFieldType(this.conversionService.fieldTypeFromClass(clazz));
            }
            if (targetField.getFieldType() == FieldType.COMPLEX) {
                String string2 = targetClassName = clazz != null && !Modifier.isAbstract(clazz.getModifiers()) ? clazz.getName() : null;
                if (targetField instanceof JavaField) {
                    ((JavaField)targetField).setClassName(targetClassName);
                } else {
                    ((JavaEnumField)targetField).setClassName(targetClassName);
                }
            }
        }
        if (sourceField instanceof JavaEnumField || targetField instanceof JavaEnumField) {
            if (!(sourceField instanceof JavaEnumField) || !(targetField instanceof JavaEnumField)) {
                AtlasUtil.addAudit(session, targetField, String.format("Value conversion between enum fields and non-enum fields is not yet supported: sourceType=%s targetType=%s targetPath=%s msg=%s", new Object[]{sourceField.getFieldType(), targetField.getFieldType(), targetField.getPath()}), AuditStatus.ERROR, sourceValue != null ? sourceValue.toString() : null);
            }
            this.populateEnumValue(session, lookupTable, (JavaEnumField)sourceField, (JavaEnumField)targetField);
            return;
        }
        JavaField javaTargetField = (JavaField)targetField;
        if (sourceValue == null) {
            if (targetField.getFieldType() != FieldType.COMPLEX) {
                AtlasUtil.addAudit(session, targetField, String.format("Null sourceValue for targetDocId=%s, targetPath=%s", targetField.getDocId(), targetField.getPath()), AuditStatus.WARN, sourceValue != null ? sourceValue.toString() : null);
                targetField.setValue(null);
                return;
            }
            if (javaTargetField.getClassName() != null) {
                Object created = this.writerUtil.instantiateObject(this.writerUtil.loadClass(javaTargetField.getClassName()));
                javaTargetField.setValue(created);
                return;
            }
        }
        Object targetValue = this.doConvertTargetValue(session, sourceValue, targetClassName, targetField);
        targetField.setValue(targetValue);
    }

    public void convertTargetValue(AtlasInternalSession session, Object parentObject, Field targetField) throws AtlasException {
        String targetClassName = targetField instanceof JavaField ? ((JavaField)targetField).getClassName() : null;
        targetClassName = targetField instanceof JavaEnumField ? ((JavaEnumField)targetField).getClassName() : targetClassName;
        Object targetValue = this.doConvertTargetValue(session, targetField.getValue(), targetClassName, targetField);
        targetField.setValue(targetValue);
    }

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    private Object doConvertTargetValue(AtlasInternalSession session, Object sourceValue, String targetClassName, Field targetField) throws AtlasException {
        if (sourceValue == null) {
            return null;
        }
        FieldType sourceType = this.conversionService.fieldTypeFromClass(sourceValue.getClass());
        FieldType targetType = targetField.getFieldType();
        Class<?> targetClazz = null;
        if (targetClassName == null) {
            if (targetType != null) {
                targetClazz = this.conversionService.classFromFieldType(targetType);
            } else {
                AtlasUtil.addAudit(session, targetField, String.format("Target field doesn't have fieldType nor className: automatic conversion won't work: targetPath=%s", targetField.getPath()), AuditStatus.WARN, sourceValue != null ? sourceValue.toString() : null);
            }
        } else if (this.conversionService.isPrimitive(targetClassName).booleanValue()) {
            targetClazz = this.conversionService.boxOrUnboxPrimitive(targetClassName);
        } else {
            try {
                targetClazz = this.classLoader.loadClass(targetClassName);
            }
            catch (ClassNotFoundException e) {
                AtlasUtil.addAudit(session, targetField, String.format("Target field class '%s' was not found: sourceType=%s targetType=%s targetPath=%s msg=%s", new Object[]{((JavaField)targetField).getClassName(), sourceType, targetType, targetField.getPath(), e.getMessage()}), AuditStatus.ERROR, null);
                return null;
            }
        }
        if (targetClazz != null) {
            if (targetField.getFieldType() == null) {
                targetField.setFieldType(this.conversionService.fieldTypeFromClass(targetClazz));
            }
            if (this.conversionService.isConvertionAvailableFor(sourceValue, targetClazz)) {
                return this.conversionService.convertType(sourceValue, null, targetClazz, null);
            }
            return null;
        }
        return sourceValue;
    }

    private Object populateEnumValue(AtlasInternalSession session, LookupTable lookupTable, JavaEnumField sourceField, JavaEnumField targetField) {
        String sourceValue;
        if (sourceField == null || sourceField.getValue() == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Input enum field or value is null, field: " + sourceField);
            }
            return null;
        }
        String targetValue = sourceValue = ((Enum)sourceField.getValue()).name();
        if (lookupTable != null) {
            for (LookupEntry e : lookupTable.getLookupEntry()) {
                if (!e.getSourceValue().equals(sourceValue)) continue;
                targetValue = e.getTargetValue();
                break;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Mapped input enum value '" + sourceValue + "' to output enum value '" + targetValue + "'.");
        }
        if (targetValue == null) {
            return null;
        }
        Class<?> enumClass = null;
        try {
            enumClass = this.classLoader.loadClass(targetField.getClassName());
        }
        catch (Exception e) {
            AtlasUtil.addAudit(session, targetField, String.format("Could not find class for output field class '%s': %s", targetField.getClassName(), e.getMessage()), AuditStatus.ERROR, targetValue);
            return null;
        }
        try {
            Object enumValue = Enum.valueOf(enumClass, targetValue);
            targetField.setValue(enumValue);
            return enumValue;
        }
        catch (IllegalArgumentException e) {
            AtlasUtil.addAudit(session, targetField, String.format("No enum entry found for value '%s': %s", targetValue, e.getMessage()), AuditStatus.ERROR, targetValue);
            return null;
        }
    }
}

