/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.java.module;

import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasValidationException;
import io.atlasmap.core.AtlasPath;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.core.BaseAtlasModule;
import io.atlasmap.java.core.JavaFieldReader;
import io.atlasmap.java.core.JavaFieldWriter;
import io.atlasmap.java.core.JavaFieldWriterUtil;
import io.atlasmap.java.core.TargetValueConverter;
import io.atlasmap.java.module.JavaValidationService;
import io.atlasmap.java.v2.AtlasJavaModelFactory;
import io.atlasmap.java.v2.JavaEnumField;
import io.atlasmap.java.v2.JavaField;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.spi.AtlasModuleDetail;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Validation;
import java.lang.reflect.Array;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtlasModuleDetail(name="JavaModule", uri="atlas:java", modes={"SOURCE", "TARGET"}, dataFormats={"java"}, configPackages={"io.atlasmap.java.v2"})
public class JavaModule
extends BaseAtlasModule {
    public static final String DEFAULT_LIST_CLASS = "java.util.ArrayList";
    private static final Logger LOG = LoggerFactory.getLogger(JavaModule.class);
    private TargetValueConverter targetValueConverter = null;
    private JavaFieldWriterUtil writerUtil = null;

    public JavaModule() {
        this.setAutomaticallyProcessOutputFieldActions(false);
    }

    @Override
    public void init() {
        this.writerUtil = new JavaFieldWriterUtil(this.getClassLoader(), this.getConversionService());
        this.targetValueConverter = new TargetValueConverter(this.getClassLoader(), this.getConversionService(), this.writerUtil);
    }

    @Override
    public void destroy() {
        this.targetValueConverter = null;
        this.writerUtil = null;
    }

    @Override
    public void processPreValidation(AtlasInternalSession atlasSession) throws AtlasException {
        if (atlasSession == null || atlasSession.getMapping() == null) {
            LOG.error("Invalid session: Session and AtlasMapping must be specified");
            throw new AtlasValidationException("Invalid session");
        }
        JavaValidationService javaValidator = new JavaValidationService(this.getConversionService(), this.getFieldActionService());
        javaValidator.setMode(this.getMode());
        javaValidator.setDocId(this.getDocId());
        List<Validation> javaValidations = javaValidator.validateMapping(atlasSession.getMapping());
        atlasSession.getValidations().getValidation().addAll(javaValidations);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Detected " + javaValidations.size() + " java validation notices");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processPreValidation completed", (Object)this.getDocId());
        }
    }

    @Override
    public void processPreSourceExecution(AtlasInternalSession atlasSession) throws AtlasException {
        if (atlasSession == null || atlasSession.getMapping() == null || atlasSession.getMapping().getMappings() == null || atlasSession.getMapping().getMappings().getMapping() == null) {
            throw new AtlasException("AtlasSession not properly intialized with a mapping that contains field mappings");
        }
        Object sourceDocument = atlasSession.getSourceDocument(this.getDocId());
        if (sourceDocument == null) {
            AtlasUtil.addAudit(atlasSession, this.getDocId(), String.format("Null source document: docId='%s'", this.getDocId()), AuditStatus.WARN, null);
        } else {
            JavaFieldReader reader = new JavaFieldReader();
            reader.setConversionService(this.getConversionService());
            reader.setDocument(sourceDocument);
            atlasSession.setFieldReader(this.getDocId(), reader);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processPreSourceExcution completed", (Object)this.getDocId());
        }
    }

    @Override
    public void processPreTargetExecution(AtlasInternalSession atlasSession) throws AtlasException {
        Object rootObject;
        if (atlasSession == null || atlasSession.getMapping() == null || atlasSession.getMapping().getMappings() == null || atlasSession.getMapping().getMappings().getMapping() == null) {
            throw new AtlasException("AtlasSession not properly intialized with a mapping that contains field mappings");
        }
        String targetClassName = AtlasUtil.unescapeFromUri(AtlasUtil.getUriParameterValue(this.getUri(), "className"));
        String collectionTypeStr = AtlasUtil.unescapeFromUri(AtlasUtil.getUriParameterValue(this.getUri(), "collectionType"));
        CollectionType collectionType = collectionTypeStr != null ? CollectionType.fromValue(collectionTypeStr) : CollectionType.NONE;
        String collectionClassName = AtlasUtil.unescapeFromUri(AtlasUtil.getUriParameterValue(this.getUri(), "collectionClassName"));
        JavaFieldWriter writer = new JavaFieldWriter(this.writerUtil);
        Class<?> clazz = this.writerUtil.loadClass(targetClassName);
        if (collectionType == CollectionType.ARRAY) {
            rootObject = Array.newInstance(clazz, 0);
        } else if (collectionType != CollectionType.NONE) {
            rootObject = collectionClassName != null ? this.writerUtil.instantiateObject(this.writerUtil.loadClass(collectionClassName)) : this.writerUtil.instantiateObject(this.writerUtil.getDefaultCollectionImplClass(collectionType));
            writer.setCollectionItemClass(clazz);
        } else {
            rootObject = this.writerUtil.instantiateObject(clazz);
        }
        writer.setRootObject(rootObject);
        writer.setTargetValueConverter(this.targetValueConverter);
        atlasSession.setFieldWriter(this.getDocId(), writer);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processPreTargetExcution completed", (Object)this.getDocId());
        }
    }

    @Override
    public void readSourceValue(AtlasInternalSession session) throws AtlasException {
        Field sourceField = session.head().getSourceField();
        JavaFieldReader reader = session.getFieldReader(this.getDocId(), JavaFieldReader.class);
        if (reader == null) {
            AtlasUtil.addAudit(session, sourceField, String.format("Source document '%s' doesn't exist", this.getDocId()), AuditStatus.ERROR, null);
            return;
        }
        reader.read(session);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processSourceFieldMapping completed: SourceField:[docId={}, path={}, type={}, value={}]", new Object[]{this.getDocId(), sourceField.getDocId(), sourceField.getPath(), sourceField.getFieldType(), sourceField.getValue()});
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void populateTargetField(AtlasInternalSession session) throws AtlasException {
        Field sourceField = session.head().getSourceField();
        Field targetField = session.head().getTargetField();
        AtlasPath path = new AtlasPath(targetField.getPath());
        FieldGroup targetFieldGroup = null;
        if (path.hasCollection() && !path.isIndexedCollection()) {
            targetFieldGroup = AtlasModelFactory.createFieldGroupFrom(targetField, true);
            session.head().setTargetField(targetFieldGroup);
        }
        JavaFieldWriter writer = session.getFieldWriter(this.getDocId(), JavaFieldWriter.class);
        if (targetFieldGroup == null) {
            void var7_10;
            if (sourceField instanceof FieldGroup) {
                List<Field> list = ((FieldGroup)sourceField).getField();
                if (list == null || list.size() == 0) {
                    return;
                }
                Integer index = targetField.getIndex();
                if (index != null) {
                    if (list.size() <= index) {
                        AtlasUtil.addAudit(session, this.getDocId(), String.format("The number of source fields (%s) is smaller than target index (%s) - ignoring", list.size(), index), AuditStatus.WARN, null);
                        return;
                    }
                    sourceField = list.get(index);
                } else {
                    sourceField = list.get(list.size() - 1);
                }
                session.head().setSourceField(sourceField);
            }
            Object var7_8 = null;
            if (null != sourceField.getValue() || null == sourceField.getValue() && targetField.getFieldType() == FieldType.COMPLEX && !(targetField instanceof JavaEnumField)) {
                Object object = writer.prepareParentObject(session);
            }
            if (var7_10 != null) {
                writer.populateTargetFieldValue(session, var7_10);
                writer.enqueueFieldAndParent(targetField, var7_10);
            }
        } else if (!(sourceField instanceof FieldGroup)) {
            Field field = targetField instanceof JavaEnumField ? new JavaEnumField() : new JavaField();
            AtlasJavaModelFactory.copyField(targetField, field, false);
            path.setVacantCollectionIndex(0);
            field.setPath(path.toString());
            targetFieldGroup.getField().add(field);
            session.head().setTargetField(field);
            Object parentObject = writer.prepareParentObject(session);
            if (parentObject != null) {
                writer.populateTargetFieldValue(session, parentObject);
                writer.enqueueFieldAndParent(field, parentObject);
            }
            session.head().setTargetField(targetFieldGroup);
        } else {
            Object object;
            if (((FieldGroup)sourceField).getField().size() == 0 && (object = writer.prepareParentObject(session)) != null) {
                writer.enqueueFieldAndParent(targetFieldGroup, object);
            }
            Object var7_12 = null;
            for (int i = 0; i < ((FieldGroup)sourceField).getField().size(); ++i) {
                void var7_13;
                Field sourceSubField = ((FieldGroup)sourceField).getField().get(i);
                Field field = targetField instanceof JavaEnumField ? new JavaEnumField() : new JavaField();
                AtlasJavaModelFactory.copyField(targetField, field, false);
                this.getCollectionHelper().copyCollectionIndexes(sourceField, sourceSubField, field, (Field)var7_13);
                Field field2 = field;
                targetFieldGroup.getField().add(field);
                session.head().setSourceField(sourceSubField);
                session.head().setTargetField(field);
                Object parentObject = writer.prepareParentObject(session);
                if (parentObject == null) continue;
                writer.populateTargetFieldValue(session, parentObject);
                writer.enqueueFieldAndParent(field, parentObject);
            }
            session.head().setSourceField(sourceField);
            session.head().setTargetField(targetFieldGroup);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processTargetFieldMapping completed: SourceField:[docId={}, path={}, type={}, value={}], TargetField:[docId={}, path={}, type={}, value={}]", new Object[]{this.getDocId(), sourceField.getDocId(), sourceField.getPath(), sourceField.getFieldType(), sourceField.getValue(), targetField.getDocId(), targetField.getPath(), targetField.getFieldType(), targetField.getValue()});
        }
    }

    @Override
    public void writeTargetValue(AtlasInternalSession session) throws AtlasException {
        JavaFieldWriter writer = session.getFieldWriter(this.getDocId(), JavaFieldWriter.class);
        writer.commitWriting(session);
    }

    @Override
    public void processPostSourceExecution(AtlasInternalSession session) throws AtlasException {
        session.removeFieldReader(this.getDocId());
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processPostSourceExecution completed", (Object)this.getDocId());
        }
    }

    @Override
    public void processPostTargetExecution(AtlasInternalSession session) throws AtlasException {
        JavaFieldWriter writer = session.getFieldWriter(this.getDocId(), JavaFieldWriter.class);
        if (writer != null && writer.getRootObject() != null) {
            session.setTargetDocument(this.getDocId(), writer.getRootObject());
        } else {
            AtlasUtil.addAudit(session, this.getDocId(), String.format("No target document created for DataSource '%s'", this.getDocId()), AuditStatus.WARN, null);
        }
        session.removeFieldWriter(this.getDocId());
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processPostTargetExecution completed", (Object)this.getDocId());
        }
    }

    @Override
    public Boolean isSupportedField(Field field) {
        if (super.isSupportedField(field).booleanValue()) {
            return true;
        }
        return field instanceof JavaField || field instanceof JavaEnumField;
    }

    @Override
    public Field cloneField(Field field) throws AtlasException {
        return AtlasJavaModelFactory.cloneJavaField(field, true);
    }

    @Override
    public JavaField createField() {
        return AtlasJavaModelFactory.createJavaField();
    }
}

