/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.validators;

import io.atlasmap.spi.AtlasValidator;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationScope;
import io.atlasmap.v2.ValidationStatus;
import java.util.List;

public class PositiveIntegerValidator
implements AtlasValidator {
    private String violationMessage;
    private ValidationScope scope;

    public PositiveIntegerValidator(ValidationScope scope, String violationMessage) {
        this.violationMessage = violationMessage;
        this.scope = scope;
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return Integer.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz);
    }

    @Override
    public void validate(Object target, List<Validation> validations, String id) {
        this.validate(target, validations, id, ValidationStatus.ERROR);
    }

    @Override
    public void validate(Object target, List<Validation> validations, String id, ValidationStatus status) {
        Integer value = (Integer)target;
        if (value == null || value < 0) {
            Validation validation = new Validation();
            validation.setScope(this.scope);
            validation.setId(id);
            validation.setMessage(String.format(this.violationMessage, target != null ? target.toString() : null));
            validation.setStatus(status);
            validations.add(validation);
        }
    }
}

