/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.validators;

import io.atlasmap.spi.AtlasValidator;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationScope;
import io.atlasmap.v2.ValidationStatus;
import java.util.List;

public class StringLengthValidator
implements AtlasValidator {
    private String violationMessage;
    private int minLength = 1;
    private int maxLength = Integer.MAX_VALUE;
    private ValidationScope scope;

    public StringLengthValidator(ValidationScope scope, String violationMessage, int minLength, int maxLength) {
        this.scope = scope;
        this.violationMessage = violationMessage;
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return String.class.isAssignableFrom(clazz);
    }

    @Override
    public void validate(Object target, List<Validation> validations, String id) {
        this.validate(target, validations, id, ValidationStatus.ERROR);
    }

    @Override
    public void validate(Object target, List<Validation> validations, String id, ValidationStatus status) {
        String value = (String)target;
        if (value.isEmpty() || value.length() > this.maxLength || value.length() < this.minLength) {
            Validation validation = new Validation();
            validation.setScope(this.scope);
            validation.setId(id);
            validation.setMessage(String.format(this.violationMessage, target.toString()));
            validation.setStatus(status);
            validations.add(validation);
        }
    }
}

