/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.validators;

import io.atlasmap.spi.AtlasValidator;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationScope;
import io.atlasmap.v2.ValidationStatus;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringPatternValidator
implements AtlasValidator {
    private String violationMessage;
    private String pattern;
    private ValidationScope scope;
    private boolean useMatch;

    public StringPatternValidator(ValidationScope scope, String violationMessage, String pattern) {
        this(scope, violationMessage, pattern, false);
    }

    public StringPatternValidator(ValidationScope scope, String violationMessage, String pattern, boolean useMatch) {
        this.violationMessage = violationMessage;
        this.pattern = pattern;
        this.scope = scope;
        this.useMatch = useMatch;
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return String.class.isAssignableFrom(clazz);
    }

    @Override
    public void validate(Object target, List<Validation> validations, String id) {
        this.validate(target, validations, id, ValidationStatus.ERROR);
    }

    @Override
    public void validate(Object target, List<Validation> validations, String id, ValidationStatus status) {
        Pattern regEx = Pattern.compile(this.pattern);
        if (target != null && this.supports(target.getClass())) {
            String value = (String)target;
            Matcher m = regEx.matcher(value);
            if (this.useMatch) {
                if (!m.matches()) {
                    Validation validation = new Validation();
                    validation.setScope(this.scope);
                    validation.setId(id);
                    validation.setMessage(String.format(this.violationMessage, target.toString()));
                    validation.setStatus(status);
                    validations.add(validation);
                }
            } else if (m.find()) {
                Validation validation = new Validation();
                validation.setScope(this.scope);
                validation.setId(id);
                validation.setMessage(String.format(this.violationMessage, target.toString()));
                validation.setStatus(status);
                validations.add(validation);
            }
        }
    }
}

