/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.core;

import io.atlasmap.core.AtlasPath;
import io.atlasmap.v2.CollectionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class XmlPath
extends AtlasPath {
    public static final String PATH_NAMESPACE_SEPARATOR = ":";

    public XmlPath(String path) {
        super(path);
    }

    public XmlPath(String path, Map<String, String> namespacesToReplace) {
        super(XmlPath.updatedPath(path, namespacesToReplace));
    }

    public List<XmlSegmentContext> getXmlSegments(boolean includeRoot) {
        int start;
        ArrayList<XmlSegmentContext> answer = new ArrayList<XmlSegmentContext>();
        for (int i = start = includeRoot ? 0 : 1; i < this.segmentContexts.size(); ++i) {
            answer.add((XmlSegmentContext)this.segmentContexts.get(i));
        }
        return Collections.unmodifiableList(answer);
    }

    @Override
    public XmlSegmentContext getLastSegment() {
        return (XmlSegmentContext)super.getLastSegment();
    }

    @Override
    public XmlPath getLastSegmentParentPath() {
        if (this.segmentContexts.isEmpty() || this.segmentContexts.size() == 1) {
            return null;
        }
        XmlPath parentPath = new XmlPath(null);
        for (int i = 0; i < this.segmentContexts.size() - 1; ++i) {
            parentPath.appendField(((AtlasPath.SegmentContext)this.segmentContexts.get(i)).getExpression());
        }
        return parentPath;
    }

    @Override
    protected XmlSegmentContext createSegmentContext(String expression) {
        return new XmlSegmentContext(expression);
    }

    private static String updatedPath(String fieldPath, Map<String, String> namespacesToReplace) {
        boolean isStartedWtSlash = false;
        String path = fieldPath;
        String updatedPath = "";
        if (namespacesToReplace != null && namespacesToReplace.size() > 0) {
            if (path != null && !"".equals(path)) {
                if (path.startsWith("/")) {
                    path = path.replaceFirst("/", "");
                    isStartedWtSlash = true;
                }
                if (path.contains("/")) {
                    String[] parts;
                    for (String part : parts = path.split("/", 512)) {
                        int index = part.indexOf(PATH_NAMESPACE_SEPARATOR);
                        if (index >= 0) {
                            String namespace;
                            if (part.startsWith("@")) {
                                namespace = part.substring(1, index);
                                if (namespacesToReplace.containsKey(namespace)) {
                                    updatedPath = updatedPath + "/" + "@" + namespacesToReplace.get(namespace) + part.substring(index);
                                    continue;
                                }
                                updatedPath = updatedPath + "/" + part;
                                continue;
                            }
                            namespace = part.substring(0, index);
                            if (namespacesToReplace.containsKey(namespace)) {
                                updatedPath = updatedPath + "/" + namespacesToReplace.get(namespace) + part.substring(index);
                                continue;
                            }
                            updatedPath = updatedPath + "/" + part;
                            continue;
                        }
                        updatedPath = updatedPath + "/" + part;
                    }
                } else {
                    updatedPath = path;
                }
                if (!isStartedWtSlash) {
                    updatedPath = updatedPath.substring(1);
                }
            } else {
                updatedPath = path;
            }
        }
        return updatedPath;
    }

    public static class XmlSegmentContext
    extends AtlasPath.SegmentContext {
        private String namespace;
        private String qname;

        public XmlSegmentContext(String expression) {
            super(expression);
            if (this.getExpression().contains(XmlPath.PATH_NAMESPACE_SEPARATOR)) {
                String[] splitted = this.getExpression().split(XmlPath.PATH_NAMESPACE_SEPARATOR);
                this.namespace = this.isAttribute() ? splitted[0].replaceFirst("@", "") : splitted[0];
                this.qname = this.namespace + XmlPath.PATH_NAMESPACE_SEPARATOR + this.getName();
            } else {
                this.qname = this.getName();
            }
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getQName() {
            return this.qname;
        }

        @Override
        protected String cleanPathSegment(String expression) {
            String answer = super.cleanPathSegment(expression);
            if (answer != null && answer.startsWith("@")) {
                answer = answer.substring(1);
            }
            return answer;
        }

        @Override
        protected XmlSegmentContext rebuild() {
            String index;
            StringBuilder buf = new StringBuilder();
            if (this.isAttribute()) {
                buf.append("@");
            }
            buf.append(this.qname);
            String string = index = this.getCollectionIndex() != null ? this.getCollectionIndex().toString() : "";
            if (this.getCollectionType() == CollectionType.ARRAY) {
                buf.append("[").append(index).append("]");
            } else if (this.getCollectionType() == CollectionType.LIST) {
                buf.append("<").append(index).append(">");
            } else if (this.getCollectionType() == CollectionType.MAP) {
                buf.append("<").append(this.getMapKey()).append(">");
            }
            return new XmlSegmentContext(buf.toString());
        }

        @Override
        public String toString() {
            return this.getCollectionType() == CollectionType.MAP ? String.format("XmlSegmentContext [namespace=%s, name=%s, expression=%s, collectionType=%s, mapKey=%s]", new Object[]{this.namespace, this.getName(), this.getExpression(), this.getCollectionType(), this.getMapKey()}) : String.format("XmlSegmentContext [namespace=%s, name=%s, expression=%s, collectionType=%s, collectionIndex=%s]", new Object[]{this.namespace, this.getName(), this.getExpression(), this.getCollectionType(), this.getCollectionIndex()});
        }
    }
}

