/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.inspect;

import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.FieldStatus;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Fields;
import io.atlasmap.xml.core.XmlComplexTypeFactory;
import io.atlasmap.xml.core.XmlPath;
import io.atlasmap.xml.v2.AtlasXmlModelFactory;
import io.atlasmap.xml.v2.XmlComplexType;
import io.atlasmap.xml.v2.XmlDocument;
import io.atlasmap.xml.v2.XmlField;
import io.atlasmap.xml.v2.XmlFields;
import io.atlasmap.xml.v2.XmlNamespace;
import io.atlasmap.xml.v2.XmlNamespaces;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlInstanceInspector {
    private static final Logger LOG = LoggerFactory.getLogger(XmlInstanceInspector.class);
    private XmlDocument xmlDocument = AtlasXmlModelFactory.createXmlDocument();

    public void inspect(Document document) {
        this.xmlDocument.setFields(new Fields());
        this.parseDocument(document.getDocumentElement());
    }

    public XmlDocument getXmlDocument() {
        return this.xmlDocument;
    }

    private void parseDocument(Node rootNode) {
        if (rootNode.getParentNode() == null || rootNode.getParentNode().getNodeType() != 9) {
            return;
        }
        XmlComplexType rootComplexType = this.createXmlComplexType(rootNode, null);
        this.xmlDocument.getFields().getField().add(rootComplexType);
        this.mapAttributes(rootNode, rootComplexType);
        if (rootNode.hasChildNodes()) {
            this.mapChildNodes(rootNode.getChildNodes(), rootComplexType);
        }
    }

    private void mapChildNodes(NodeList nodes, XmlComplexType rootComplexType) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node childNode = nodes.item(i);
            if (!Arrays.asList((short)1, (short)2).contains(childNode.getNodeType())) continue;
            if (childNode.hasAttributes()) {
                this.mapAttributes(childNode, rootComplexType);
            }
            if (((Element)childNode).getElementsByTagName("*").getLength() > 0) {
                this.mapParentNode(childNode, rootComplexType);
                continue;
            }
            this.mapNodeToXmlField(childNode, rootComplexType);
        }
    }

    private void mapNamespace(Node node) {
        Object namespaces;
        if (this.xmlDocument.getXmlNamespaces() == null) {
            namespaces = new XmlNamespaces();
            this.xmlDocument.setXmlNamespaces((XmlNamespaces)namespaces);
        }
        if ((namespaces = this.xmlDocument.getXmlNamespaces().getXmlNamespace()).stream().noneMatch(ns -> {
            if (ns.getAlias() == null) {
                return node.getPrefix() == null && ns.getUri().equals(node.getNamespaceURI());
            }
            return ns.getAlias().equals(node.getPrefix());
        })) {
            XmlNamespace namespace = new XmlNamespace();
            namespace.setAlias(node.getPrefix());
            namespace.setUri(node.getNamespaceURI());
            namespaces.add(namespace);
        }
    }

    private void mapParentNode(Node node, XmlComplexType parent) {
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList childNodes = node.getChildNodes();
        XmlComplexType childParent = null;
        XmlField[] existing = (XmlField[])parent.getXmlFields().getXmlField().stream().filter(f -> f.getName().equals(node.getNodeName()) && f.getFieldType() == FieldType.COMPLEX).toArray(XmlField[]::new);
        if (existing.length > 0) {
            childParent = (XmlComplexType)existing[0];
            if (existing.length > 1) {
                LOG.warn("Ignoring duplicate complex field '{}'", (Object)childParent.getPath());
            }
            this.updateCollectionType(node.getParentNode(), childParent);
        } else {
            childParent = this.createXmlComplexType(node, parent);
            parent.getXmlFields().getXmlField().add(childParent);
        }
        if (node.hasAttributes()) {
            this.mapAttributes(node, childParent);
        }
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node e = childNodes.item(i);
            if (e.getNodeType() != 1) continue;
            NodeList childElements = ((Element)e).getElementsByTagName("*");
            if (childElements.getLength() > 0) {
                this.mapParentNode(e, childParent);
                continue;
            }
            this.mapNodeToXmlField(e, childParent);
            if (!e.hasAttributes()) continue;
            this.mapAttributes(e, childParent);
        }
        if (node.getNamespaceURI() != null) {
            this.mapNamespace(node);
        }
    }

    private void mapAttributes(Node node, XmlComplexType xmlComplexType) {
        NamedNodeMap attrs = node.getAttributes();
        if (attrs == null) {
            return;
        }
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attrNode = attrs.item(i);
            if (attrNode.getNamespaceURI() != null && attrNode.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) continue;
            if (attrNode.getNamespaceURI() != null && attrNode.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema-instance")) {
                this.mapNamespace(attrNode);
                xmlComplexType.setTypeName(attrNode.getTextContent());
                continue;
            }
            if (attrNode.getNamespaceURI() != null) {
                this.mapNamespace(attrNode);
            }
            this.mapNodeToXmlField(attrNode, xmlComplexType);
        }
    }

    private void mapNodeToXmlField(Node node, XmlComplexType parentComplexType) {
        XmlField[] existing;
        XmlField xmlField = null;
        if (node.getNodeType() == 2) {
            existing = (XmlField[])parentComplexType.getXmlFields().getXmlField().stream().filter(f -> f.getName().equals(node.getNodeName()) && f.isAttribute() != false).toArray(XmlField[]::new);
            if (existing.length > 0) {
                xmlField = existing[0];
                if (existing.length > 1) {
                    LOG.error("Ignoring duplicated attribute '{}'", (Object)xmlField.getPath());
                }
            }
        } else {
            existing = (XmlField[])parentComplexType.getXmlFields().getXmlField().stream().filter(f -> f.getName().equals(node.getNodeName()) && f.isAttribute() == false).toArray(XmlField[]::new);
            if (existing.length > 0) {
                xmlField = existing[0];
                if (existing.length > 1) {
                    LOG.warn("Ignoring duplicated element '{}'", (Object)xmlField.getPath());
                }
            }
        }
        if (xmlField == null) {
            xmlField = AtlasXmlModelFactory.createXmlField();
            xmlField.setValue(node.getTextContent());
            xmlField.setFieldType(FieldType.STRING);
            xmlField.setName(node.getNodeName());
            xmlField.setStatus(FieldStatus.SUPPORTED);
            xmlField.setAttribute(node.getNodeType() == 2);
            parentComplexType.getXmlFields().getXmlField().add(xmlField);
            StringBuffer fieldPath = new StringBuffer();
            if (node.getNodeType() == 2) {
                fieldPath.append("@");
            }
            fieldPath.append(node.getNodeName());
            XmlPath path = new XmlPath(parentComplexType.getPath());
            path.appendField(fieldPath.toString());
            xmlField.setPath(path.toString());
        }
        if (node.getNodeType() == 1) {
            this.updateCollectionType(node.getParentNode(), xmlField);
        }
        if (node.getNamespaceURI() != null) {
            this.mapNamespace(node);
        }
    }

    private XmlComplexType createXmlComplexType(Node childNode, XmlComplexType parentField) {
        XmlComplexType childComplexType = XmlComplexTypeFactory.createXmlComlexField();
        childComplexType.setXmlFields(new XmlFields());
        childComplexType.setName(childNode.getNodeName());
        XmlPath path = null;
        if (parentField == null) {
            path = new XmlPath("/" + childNode.getNodeName());
        } else {
            path = new XmlPath(parentField.getPath());
            Element parentElement = (Element)childNode.getParentNode();
            if (this.isCollection(parentElement, childNode.getNodeName())) {
                childComplexType.setCollectionType(CollectionType.LIST);
                path.appendField(childNode.getNodeName() + "<" + ">");
            } else {
                childComplexType.setCollectionType(CollectionType.NONE);
                path.appendField(childNode.getNodeName());
            }
        }
        childComplexType.setPath(path.toString());
        return childComplexType;
    }

    private void updateCollectionType(Node parentNode, XmlField field) {
        if (field.getCollectionType() == CollectionType.LIST || parentNode.getNodeType() != 1) {
            return;
        }
        if (!this.isCollection((Element)parentNode, field.getName())) {
            return;
        }
        field.setCollectionType(CollectionType.LIST);
        field.setPath(field.getPath() + "<" + ">");
        if (field instanceof XmlComplexType) {
            XmlComplexType complex = (XmlComplexType)field;
            for (XmlField child : complex.getXmlFields().getXmlField()) {
                this.updateFieldPathFromParent(child, complex);
            }
        }
    }

    private boolean isCollection(Element parent, String name) {
        NodeList siblings = parent.getChildNodes();
        ArrayList<Element> dups = new ArrayList<Element>();
        for (int i = 0; i < siblings.getLength(); ++i) {
            Node n = siblings.item(i);
            if (n.getNodeType() != 1 || !n.getNodeName().equals(name)) continue;
            dups.add((Element)n);
        }
        return dups.size() > 1;
    }

    private void updateFieldPathFromParent(XmlField child, XmlComplexType parent) {
        XmlPath oldPath = new XmlPath(child.getPath());
        XmlPath newPath = new XmlPath(parent.getPath());
        newPath.appendField(oldPath.getLastSegment().getExpression());
        child.setPath(newPath.toString());
        if (child instanceof XmlComplexType) {
            for (XmlField grandChild : ((XmlComplexType)child).getXmlFields().getXmlField()) {
                this.updateFieldPathFromParent(grandChild, (XmlComplexType)child);
            }
        }
    }
}

