/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.maven;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.atlasmap.api.AtlasConversionService;
import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.java.inspect.ClassInspectionService;
import io.atlasmap.java.service.AtlasJsonProvider;
import io.atlasmap.java.v2.JavaClass;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;

@Mojo(name="generate-inspections")
public class GenerateInspectionsMojo
extends AbstractMojo {
    @Component
    private RepositorySystem system;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/atlasmap")
    private File outputDir;
    @Parameter
    private File outputFile;
    @Parameter
    private List<String> artifacts;
    @Parameter(property="className")
    private String className;
    @Parameter
    private List<Inspection> inspections;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.outputDir != null) {
            this.outputDir.mkdirs();
        }
        if (this.artifacts != null && this.className != null) {
            this.generateInspection(this.artifacts, Arrays.asList(this.className));
        }
        if (this.inspections != null) {
            for (Inspection inspection : this.inspections) {
                ArrayList<String> classNames = new ArrayList<String>();
                if (inspection.classNames != null) {
                    classNames.addAll(inspection.classNames);
                } else if (inspection.className != null) {
                    classNames.add(inspection.className);
                } else {
                    throw new MojoExecutionException("None of classNames nor className was found in the inspection configuration");
                }
                this.generateInspection(inspection.artifacts, classNames);
            }
        }
    }

    private void generateInspection(List<String> artifacts, Collection<String> classNames) throws MojoFailureException, MojoExecutionException {
        List<URL> urls = artifacts == null ? Collections.emptyList() : this.resolveClasspath(artifacts);
        ClassLoader origTccl = Thread.currentThread().getContextClassLoader();
        for (String className : classNames) {
            Class<?> clazz = null;
            JavaClass c = null;
            try (URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), origTccl);){
                clazz = loader.loadClass(className);
                ClassInspectionService classInspectionService = new ClassInspectionService();
                classInspectionService.setConversionService((AtlasConversionService)DefaultAtlasConversionService.getInstance());
                c = classInspectionService.inspectClass((ClassLoader)loader, clazz);
            }
            catch (IOException | ClassNotFoundException e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
            try {
                ObjectMapper objectMapper = AtlasJsonProvider.createObjectMapper();
                File target = this.outputFile;
                if (target == null) {
                    target = new File(this.outputDir, "atlasmap-inpection-" + className + ".json");
                }
                objectMapper.writeValue(target, (Object)c);
                this.getLog().info((CharSequence)("Created: " + target));
            }
            catch (JsonProcessingException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
    }

    private List<URL> resolveClasspath(List<String> artifacts) throws MojoFailureException {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            for (String gav : artifacts) {
                DefaultArtifact artifact = new DefaultArtifact(gav);
                this.getLog().debug((CharSequence)("Resolving dependencies for artifact: " + artifact));
                CollectRequest collectRequest = new CollectRequest();
                collectRequest.setRoot(new Dependency((Artifact)artifact, ""));
                collectRequest.setRepositories(this.remoteRepos);
                DependencyRequest dependencyRequest = new DependencyRequest();
                dependencyRequest.setCollectRequest(collectRequest);
                DependencyResult dependencyResult = this.system.resolveDependencies(this.repoSession, dependencyRequest);
                PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
                dependencyResult.getRoot().accept((DependencyVisitor)nlg);
                for (DependencyNode node : nlg.getNodes()) {
                    Artifact x;
                    if (node.getDependency() == null || (x = node.getDependency().getArtifact()).getFile() == null) continue;
                    this.getLog().debug((CharSequence)("Found dependency: " + x + " for artifact: " + artifact));
                    urls.add(x.getFile().toURI().toURL());
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        catch (DependencyResolutionException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        return urls;
    }

    public RepositorySystem getSystem() {
        return this.system;
    }

    public void setSystem(RepositorySystem system) {
        this.system = system;
    }

    public List<RemoteRepository> getRemoteRepos() {
        return this.remoteRepos;
    }

    public void setRemoteRepos(List<RemoteRepository> remoteRepos) {
        this.remoteRepos = remoteRepos;
    }

    public RepositorySystemSession getRepoSession() {
        return this.repoSession;
    }

    public void setRepoSession(RepositorySystemSession repoSession) {
        this.repoSession = repoSession;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public List<String> getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(List<String> artifacts) {
        this.artifacts = artifacts;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public List<Inspection> getInspections() {
        return this.inspections;
    }

    public void setInspections(List<Inspection> inspections) {
        this.inspections = inspections;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public static class Inspection {
        private List<String> artifacts;
        private String className;
        private List<String> classNames;

        public String getClassName() {
            return this.className;
        }

        public List<String> getClassNames() {
            return this.classNames;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public void setClassNames(List<String> classNames) {
            this.classNames = classNames;
        }

        public List<String> getArtifacts() {
            return this.artifacts;
        }

        public void setArtifacts(List<String> artifacts) {
            this.artifacts = artifacts;
        }
    }
}

