/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.standalone;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.DefaultCsrfToken;

public class AtlasMapXsrfRepository
implements CsrfTokenRepository {
    private static final String XSRF_HEADER_NAME = "ATLASMAP-XSRF-TOKEN";
    private static final String XSRF_HEADER_VALUE = "awesome";
    private static final Logger LOG = LoggerFactory.getLogger(AtlasMapXsrfRepository.class);

    public CsrfToken generateToken(HttpServletRequest httpServletRequest) {
        return new DefaultCsrfToken(XSRF_HEADER_NAME, XSRF_HEADER_NAME, XSRF_HEADER_VALUE);
    }

    public void saveToken(CsrfToken csrfToken, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (csrfToken != null && csrfToken.getHeaderName() != null && csrfToken.getToken() != null) {
            httpServletResponse.setHeader(csrfToken.getHeaderName(), csrfToken.getToken());
        }
    }

    public CsrfToken loadToken(HttpServletRequest httpServletRequest) {
        Optional token = this.extractToken(httpServletRequest);
        if (token.isPresent()) {
            LOG.trace("Xsrf token found in request to uri {}. Value is: {}", (Object)httpServletRequest.getRequestURI(), token.get());
        } else {
            LOG.trace("Xsrf token not found in request to uri {}", (Object)httpServletRequest.getRequestURI());
        }
        return token.map(val -> new DefaultCsrfToken(XSRF_HEADER_NAME, XSRF_HEADER_NAME, val)).orElse(null);
    }

    private Optional<String> extractToken(HttpServletRequest request) {
        String token = request.getHeader(XSRF_HEADER_NAME);
        return Optional.ofNullable(token);
    }
}

