/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atlasmap;

import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasContextFactory;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.ADMArchiveHandler;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.Audit;
import io.atlasmap.v2.DataSource;
import io.atlasmap.v2.DataSourceType;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.ResourceEndpoint;
import org.apache.camel.component.atlasmap.AtlasComponent;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.19.0", scheme="atlas", title="AtlasMap", syntax="atlas:resourceUri", producerOnly=true, label="transformation")
public class AtlasEndpoint
extends ResourceEndpoint {
    public static final String CONTENT_TYPE_JSON = "application/json";
    public static final String CONTENT_TYPE_XML = "application/xml";
    private static final Logger LOG = LoggerFactory.getLogger(AtlasEndpoint.class);
    private AtlasContextFactory atlasContextFactory;
    private AtlasContext atlasContext;
    @UriParam(defaultValue="true")
    private boolean loaderCache = true;
    @UriParam
    private String encoding;
    @UriParam
    private String propertiesFile;
    @UriParam
    private String sourceMapName;
    @UriParam
    private String targetMapName;

    public AtlasEndpoint(String uri, AtlasComponent component, String resourceUri) {
        super(uri, (Component)component, resourceUri);
    }

    public boolean isSingleton() {
        return true;
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    protected String createEndpointUri() {
        return "atlas:" + this.getResourceUri();
    }

    public AtlasContextFactory getAtlasContextFactory() {
        return this.atlasContextFactory;
    }

    public void setAtlasContextFactory(AtlasContextFactory atlasContextFactory) {
        this.atlasContextFactory = atlasContextFactory;
    }

    public AtlasContext getAtlasContext() {
        return this.atlasContext;
    }

    public void setAtlasContext(AtlasContext atlasContext) {
        this.atlasContext = atlasContext;
    }

    public boolean isLoaderCache() {
        return this.loaderCache;
    }

    public void setLoaderCache(boolean loaderCache) {
        this.loaderCache = loaderCache;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setPropertiesFile(String file) {
        this.propertiesFile = file;
    }

    public String getPropertiesFile() {
        return this.propertiesFile;
    }

    public void setSourceMapName(String name) {
        this.sourceMapName = name;
    }

    public String getSourceMapName() {
        return this.sourceMapName;
    }

    public void setTargetMapName(String name) {
        this.targetMapName = name;
    }

    public String getTargetMapName() {
        return this.targetMapName;
    }

    public AtlasEndpoint findOrCreateEndpoint(String uri, String newResourceUri) {
        String newUri = uri.replace(this.getResourceUri(), newResourceUri);
        this.log.debug("Getting endpoint with URI: {}", (Object)newUri);
        return (AtlasEndpoint)this.getCamelContext().getEndpoint(newUri, AtlasEndpoint.class);
    }

    private String extractMappingsFromADM(InputStream in, String admPath) throws Exception {
        try {
            ADMArchiveHandler handler = new ADMArchiveHandler(this.getCamelContext().getApplicationContextClassLoader());
            handler.setIgnoreLibrary(true);
            handler.load(in);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Atlas mapping content extracted from ADM archive: {}", (Object)admPath);
            }
            return new String(handler.getMappingDefinitionBytes());
        }
        catch (Exception e) {
            throw new IOException("Error extracting mappings file from ADM archive " + admPath, e);
        }
    }

    protected void onExchange(Exchange exchange) throws Exception {
        Message incomingMessage = exchange.getIn();
        String newResourceUri = (String)incomingMessage.getHeader("CamelAtlasResourceUri", String.class);
        if (newResourceUri != null) {
            incomingMessage.removeHeader("CamelAtlasResourceUri");
            this.log.debug("{} set to {} creating new endpoint to handle exchange", (Object)"CamelAtlasResourceUri", (Object)newResourceUri);
            AtlasEndpoint newEndpoint = this.findOrCreateEndpoint(this.getEndpointUri(), newResourceUri);
            newEndpoint.onExchange(exchange);
            return;
        }
        AtlasSession atlasSession = this.getOrCreateAtlasContext(incomingMessage).createSession();
        this.populateSourceDocuments(exchange, atlasSession);
        atlasSession.getAtlasContext().process(atlasSession);
        ArrayList<Audit> errors = new ArrayList<Audit>();
        block4: for (Audit audit : atlasSession.getAudits().getAudit()) {
            switch (audit.getStatus()) {
                case ERROR: {
                    errors.add(audit);
                    continue block4;
                }
                case WARN: {
                    LOG.warn("{}: docId='{}', path='{}'", new Object[]{audit.getMessage(), audit.getDocId(), audit.getPath()});
                    continue block4;
                }
            }
            LOG.info("{}: docId='{}', path='{}'", new Object[]{audit.getMessage(), audit.getDocId(), audit.getPath()});
        }
        if (!errors.isEmpty()) {
            StringBuilder buf = new StringBuilder("Errors: ");
            errors.stream().forEach(a -> buf.append(String.format("[%s: docId='%s', path='%s'], ", a.getMessage(), a.getDocId(), a.getPath())));
            throw new AtlasException(buf.toString());
        }
        this.populateTargetDocuments(atlasSession, exchange);
    }

    private AtlasContext getOrCreateAtlasContext(Message incomingMessage) throws Exception {
        String path = this.getResourceUri();
        ObjectHelper.notNull((Object)path, (String)"mappingUri");
        Reader reader = null;
        String content = (String)incomingMessage.getHeader("CamelAtlasMapping", String.class);
        if (content != null) {
            reader = new StringReader(content);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Atlas mapping content read from header {} for endpoint {}", (Object)"CamelAtlasMapping", (Object)this.getEndpointUri());
            }
            incomingMessage.removeHeader("CamelAtlasMapping");
            AtlasMapping mapping = ((DefaultAtlasContextFactory)this.getOrCreateAtlasContextFactory()).getMappingService().loadMapping(reader);
            return ((DefaultAtlasContextFactory)this.getOrCreateAtlasContextFactory()).createContext(mapping);
        }
        if (this.getAtlasContext() != null) {
            return this.getAtlasContext();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Atlas mapping content read from resourceUri: {} for endpoint {}", new Object[]{path, this.getEndpointUri()});
        }
        if (path.toLowerCase().endsWith("adm")) {
            ADMArchiveHandler handler = new ADMArchiveHandler(this.getCamelContext().getApplicationContextClassLoader());
            handler.setIgnoreLibrary(true);
            handler.load(this.getResourceAsInputStream());
            if (this.log.isDebugEnabled()) {
                this.log.debug("AtlasMap mapping definition and data sources extracted from ADM archive: {}", (Object)path);
            }
            this.atlasContext = ((DefaultAtlasContextFactory)this.getOrCreateAtlasContextFactory()).createContext(handler.getMappingDefinition());
            ((DefaultAtlasContext)this.atlasContext).setDataSourceMetadata(handler.getDataSourceMetadataMap());
        } else {
            reader = this.getEncoding() != null ? new InputStreamReader(this.getResourceAsInputStream(), this.getEncoding()) : new InputStreamReader(this.getResourceAsInputStream());
            AtlasMapping mapping = ((DefaultAtlasContextFactory)this.getOrCreateAtlasContextFactory()).getMappingService().loadMapping(reader);
            this.atlasContext = ((DefaultAtlasContextFactory)this.getOrCreateAtlasContextFactory()).createContext(mapping);
        }
        return this.atlasContext;
    }

    private synchronized AtlasContextFactory getOrCreateAtlasContextFactory() throws Exception {
        if (this.atlasContextFactory != null) {
            return this.atlasContextFactory;
        }
        this.atlasContextFactory = DefaultAtlasContextFactory.getInstance();
        ((DefaultAtlasContextFactory)this.atlasContextFactory).addClassLoader(this.getCamelContext().getApplicationContextClassLoader());
        if (ObjectHelper.isNotEmpty((Object)this.getPropertiesFile())) {
            Properties properties = new Properties();
            InputStream reader = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.getCamelContext(), (String)this.getPropertiesFile());
            try {
                properties.load(reader);
                this.log.info("Loaded the Atlas properties file " + this.getPropertiesFile());
            }
            finally {
                IOHelper.close((Closeable)reader, (String)this.getPropertiesFile(), (Logger)this.log);
            }
            this.log.debug("Initializing AtlasContextFactory with properties {}", (Object)properties);
            this.atlasContextFactory.setProperties(properties);
        }
        return this.atlasContextFactory;
    }

    private void populateSourceDocuments(Exchange exchange, AtlasSession session) {
        if (session.getMapping().getDataSource() == null) {
            return;
        }
        DataSource[] sourceDataSources = (DataSource[])session.getMapping().getDataSource().stream().filter(ds -> ds.getDataSourceType() == DataSourceType.SOURCE).toArray(DataSource[]::new);
        if (sourceDataSources.length == 0) {
            session.setDefaultSourceDocument(exchange.getIn().getBody());
            return;
        }
        if (sourceDataSources.length == 1) {
            String docId = sourceDataSources[0].getId();
            Object payload = this.extractPayload(sourceDataSources[0], exchange.getIn());
            if (docId == null || docId.isEmpty()) {
                session.setDefaultSourceDocument(payload);
            } else {
                session.setSourceDocument(docId, payload);
            }
            return;
        }
        Map sourceMessages = null;
        Map sourceDocuments = null;
        if (this.sourceMapName != null) {
            sourceMessages = (Map)exchange.getProperty(this.sourceMapName, Map.class);
        }
        if (sourceMessages == null) {
            Object body = exchange.getIn().getBody();
            if (body instanceof Map) {
                sourceDocuments = (Map)body;
            } else {
                session.setDefaultSourceDocument(body);
                return;
            }
        }
        for (DataSource ds2 : sourceDataSources) {
            Object payload;
            String docId = ds2.getId();
            Object object = payload = sourceMessages != null ? this.extractPayload(ds2, (Message)sourceMessages.get(docId)) : sourceDocuments.get(docId);
            if (docId == null || docId.isEmpty()) {
                session.setDefaultSourceDocument(payload);
                continue;
            }
            session.setSourceDocument(docId, payload);
        }
    }

    private Object extractPayload(DataSource dataSource, Message message) {
        if (dataSource == null || message == null) {
            return null;
        }
        Object body = null;
        body = dataSource != null && dataSource.getUri() != null && !dataSource.getUri().startsWith("atlas:core") && !dataSource.getUri().startsWith("atlas:java") ? message.getBody(String.class) : message.getBody();
        MessageHelper.resetStreamCache((Message)message);
        return body;
    }

    private void populateTargetDocuments(AtlasSession session, Exchange exchange) {
        Message message = exchange.getMessage();
        if (session.getMapping().getDataSource() == null) {
            return;
        }
        DataSource[] targetDataSources = (DataSource[])session.getMapping().getDataSource().stream().filter(ds -> ds.getDataSourceType() == DataSourceType.TARGET).toArray(DataSource[]::new);
        if (targetDataSources.length == 0) {
            Object newBody = session.getDefaultTargetDocument();
            message.setBody(newBody);
            return;
        }
        if (targetDataSources.length == 1) {
            String docId = targetDataSources[0].getId();
            if (docId == null || docId.isEmpty()) {
                Object newBody = session.getDefaultTargetDocument();
                message.setBody(newBody);
            } else {
                Object newBody = session.getTargetDocument(docId);
                message.setBody(newBody);
            }
            this.setContentType(targetDataSources[0], message);
            return;
        }
        HashMap<String, Object> targetDocuments = new HashMap<String, Object>();
        for (DataSource ds2 : targetDataSources) {
            String docId = ds2.getId();
            if (docId == null || docId.isEmpty()) {
                targetDocuments.put("ATLAS_DEFAULT_TARGET_DOC", session.getDefaultTargetDocument());
                Object newBody = session.getDefaultTargetDocument();
                message.setBody(newBody);
                this.setContentType(ds2, message);
                continue;
            }
            targetDocuments.put(docId, session.getTargetDocument(docId));
        }
        if (this.targetMapName != null) {
            exchange.setProperty(this.targetMapName, targetDocuments);
        } else {
            message.setBody(targetDocuments);
        }
    }

    private void setContentType(DataSource ds, Message message) {
        if (ds.getUri() == null) {
            return;
        }
        if (ds.getUri().startsWith("atlas:json")) {
            message.setHeader("Content-Type", (Object)CONTENT_TYPE_JSON);
        } else if (ds.getUri().startsWith("atlas:xml")) {
            message.setHeader("Content-Type", (Object)CONTENT_TYPE_XML);
        }
    }
}

