/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atlasmap;

import io.atlasmap.api.AtlasContextFactory;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.atlasmap.AtlasEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.ResourceHelper;

public class AtlasComponent
extends DefaultComponent {
    @Metadata(label="advanced")
    private AtlasContextFactory atlasContextFactory;

    public AtlasContextFactory getAtlasContextFactory() {
        return this.atlasContextFactory;
    }

    public void setAtlasContextFactory(AtlasContextFactory atlasContextFactory) {
        this.atlasContextFactory = atlasContextFactory;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        boolean cache = (Boolean)this.getAndRemoveParameter(parameters, "contentCache", Boolean.class, Boolean.TRUE);
        String sourceMapName = (String)this.getAndRemoveParameter(parameters, "sourceMapName", String.class);
        String targetMapName = (String)this.getAndRemoveParameter(parameters, "targetMapName", String.class);
        AtlasEndpoint.TargetMapMode targetMapMode = (AtlasEndpoint.TargetMapMode)((Object)this.getAndRemoveParameter(parameters, "targetMapMode", AtlasEndpoint.TargetMapMode.class));
        AtlasEndpoint endpoint = new AtlasEndpoint(uri, this, remaining);
        this.setProperties((Endpoint)endpoint, parameters);
        endpoint.setContentCache(cache);
        endpoint.setSourceMapName(sourceMapName);
        endpoint.setTargetMapName(targetMapName);
        endpoint.setAtlasContextFactory(this.getAtlasContextFactory());
        if (targetMapMode != null) {
            endpoint.setTargetMapMode(targetMapMode);
        }
        if (ResourceHelper.isHttpUri((String)remaining)) {
            String remainingAndParameters = ResourceHelper.appendParameters((String)remaining, parameters);
            endpoint.setResourceUri(remainingAndParameters);
        }
        return endpoint;
    }
}

