/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.fugue.hamcrest;

import io.atlassian.fugue.Either;
import io.atlassian.fugue.Unit;
import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class EitherMatchers {
    private EitherMatchers() {
        throw new UnsupportedOperationException();
    }

    public static <L> Matcher<Either<L, ?>> isLeft(Matcher<? super L> subMatcher) {
        return new LeftMatcher(Objects.requireNonNull(subMatcher, "subMatcher"));
    }

    public static <R> Matcher<Either<?, R>> isRight(Matcher<? super R> subMatcher) {
        return new RightMatcher(Objects.requireNonNull(subMatcher, "subMatcher"));
    }

    private static class RightMatcher<R>
    extends TypeSafeMatcher<Either<?, R>> {
        private final Matcher<? super R> subMatcher;

        private RightMatcher(Matcher<? super R> subMatcher) {
            this.subMatcher = subMatcher;
        }

        protected boolean matchesSafely(Either<?, R> actual) {
            return actual.right().exists(arg_0 -> this.subMatcher.matches(arg_0));
        }

        public void describeTo(Description description) {
            description.appendText("right that ");
            this.subMatcher.describeTo(description);
        }

        protected void describeMismatchSafely(Either<?, R> actual, Description mismatchDescription) {
            actual.fold(left -> {
                mismatchDescription.appendText("was left");
                return Unit.Unit();
            }, right -> {
                mismatchDescription.appendText("was right that ");
                this.subMatcher.describeMismatch(right, mismatchDescription);
                return Unit.Unit();
            });
        }
    }

    private static class LeftMatcher<L>
    extends TypeSafeMatcher<Either<L, ?>> {
        private final Matcher<? super L> subMatcher;

        private LeftMatcher(Matcher<? super L> subMatcher) {
            this.subMatcher = subMatcher;
        }

        protected boolean matchesSafely(Either<L, ?> actual) {
            return actual.left().exists(arg_0 -> this.subMatcher.matches(arg_0));
        }

        public void describeTo(Description description) {
            description.appendText("left that ");
            this.subMatcher.describeTo(description);
        }

        protected void describeMismatchSafely(Either<L, ?> actual, Description mismatchDescription) {
            actual.fold(left -> {
                mismatchDescription.appendText("was left that ");
                this.subMatcher.describeMismatch(left, mismatchDescription);
                return Unit.Unit();
            }, right -> {
                mismatchDescription.appendText("was right");
                return Unit.Unit();
            });
        }
    }
}

