/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.fugue.hamcrest;

import io.atlassian.fugue.Try;
import io.atlassian.fugue.Unit;
import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public final class TryMatchers {
    private TryMatchers() {
        throw new UnsupportedOperationException();
    }

    public static Matcher<Try<?>> isFailure(Matcher<? super Exception> subMatcher) {
        return new FailureMatcher(Objects.requireNonNull(subMatcher, "subMatcher"));
    }

    public static Matcher<Try<?>> isFailure() {
        return new FailureMatcher(Matchers.any(Exception.class));
    }

    public static <A> Matcher<Try<A>> isSuccessful(Matcher<? super A> subMatcher) {
        return new SuccessfulMatcher(Objects.requireNonNull(subMatcher, "subMatcher"));
    }

    private static class SuccessfulMatcher<A>
    extends TypeSafeMatcher<Try<A>> {
        private final Matcher<? super A> subMatcher;

        private SuccessfulMatcher(Matcher<? super A> subMatcher) {
            this.subMatcher = subMatcher;
        }

        protected boolean matchesSafely(Try<A> actual) {
            return actual.toEither().right().exists(arg_0 -> this.subMatcher.matches(arg_0));
        }

        public void describeTo(Description description) {
            description.appendText("successful that ");
            this.subMatcher.describeTo(description);
        }

        protected void describeMismatchSafely(Try<A> actual, Description mismatchDescription) {
            actual.fold(left -> {
                mismatchDescription.appendText("was failure");
                return Unit.Unit();
            }, right -> {
                mismatchDescription.appendText("was successful that ");
                this.subMatcher.describeMismatch(right, mismatchDescription);
                return Unit.Unit();
            });
        }
    }

    private static class FailureMatcher
    extends TypeSafeMatcher<Try<?>> {
        private final Matcher<? super Exception> subMatcher;

        private FailureMatcher(Matcher<? super Exception> subMatcher) {
            this.subMatcher = subMatcher;
        }

        protected boolean matchesSafely(Try<?> actual) {
            return actual.toEither().left().exists(arg_0 -> this.subMatcher.matches(arg_0));
        }

        public void describeTo(Description description) {
            description.appendText("failure that ");
            this.subMatcher.describeTo(description);
        }

        protected void describeMismatchSafely(Try<?> actual, Description mismatchDescription) {
            actual.fold(left -> {
                mismatchDescription.appendText("was failure that ");
                this.subMatcher.describeMismatch(left, mismatchDescription);
                return Unit.Unit();
            }, right -> {
                mismatchDescription.appendText("was successful");
                return Unit.Unit();
            });
        }
    }
}

