package kadai
package log

import scalaz.Show
import scala.reflect.ClassTag

/**
 * LogMessages get fed to loggers, allowing custom control of the message
 * String.
 * 
 * Normally, you just supply whatever Show instance for your data you want
 * to control the log output, but custom sub-types may implement structured
 * log formats such as JSON.
 */
trait LogMessage {
  type M

  def value: M

  /** for producing the message String */
  def show: Show[M]

  override final def toString =
    show.shows(value)
}
