/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.concurrent;

import io.atomix.catalyst.concurrent.CatalystThread;
import io.atomix.catalyst.concurrent.CatalystThreadFactory;
import io.atomix.catalyst.concurrent.Runnables;
import io.atomix.catalyst.concurrent.Scheduled;
import io.atomix.catalyst.concurrent.ThreadContext;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleThreadContext
implements ThreadContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleThreadContext.class);
    private final ScheduledExecutorService executor;
    private final Serializer serializer;
    private volatile boolean blocked;
    private final Executor wrappedExecutor = new Executor(){

        @Override
        public void execute(Runnable command) {
            try {
                SingleThreadContext.this.executor.execute(Runnables.logFailure(command, LOGGER));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    };

    public SingleThreadContext(String nameFormat, Serializer serializer) {
        this(new CatalystThreadFactory(nameFormat), serializer);
    }

    public SingleThreadContext(CatalystThreadFactory factory, Serializer serializer) {
        this(new ScheduledThreadPoolExecutor(1, factory), serializer);
    }

    public SingleThreadContext(ScheduledExecutorService executor, Serializer serializer) {
        this(SingleThreadContext.getThread(executor), executor, serializer);
    }

    public SingleThreadContext(Thread thread, ScheduledExecutorService executor, Serializer serializer) {
        this.executor = executor;
        this.serializer = serializer;
        Assert.state(thread instanceof CatalystThread, "not a Catalyst thread", new Object[0]);
        ((CatalystThread)thread).setContext(this);
    }

    protected static CatalystThread getThread(ExecutorService executor) {
        AtomicReference thread = new AtomicReference();
        try {
            executor.submit(() -> thread.set((CatalystThread)Thread.currentThread())).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException("failed to initialize thread state", e);
        }
        return (CatalystThread)thread.get();
    }

    @Override
    public void block() {
        this.blocked = true;
    }

    @Override
    public void unblock() {
        this.blocked = false;
    }

    @Override
    public boolean isBlocked() {
        return this.blocked;
    }

    @Override
    public Logger logger() {
        return LOGGER;
    }

    @Override
    public Serializer serializer() {
        return this.serializer;
    }

    @Override
    public Executor executor() {
        return this.wrappedExecutor;
    }

    @Override
    public Scheduled schedule(Duration delay, Runnable runnable) {
        ScheduledFuture<?> future = this.executor.schedule(Runnables.logFailure(runnable, LOGGER), delay.toMillis(), TimeUnit.MILLISECONDS);
        return () -> future.cancel(false);
    }

    @Override
    public Scheduled schedule(Duration delay, Duration interval, Runnable runnable) {
        ScheduledFuture<?> future = this.executor.scheduleAtFixedRate(Runnables.logFailure(runnable, LOGGER), delay.toMillis(), interval.toMillis(), TimeUnit.MILLISECONDS);
        return () -> future.cancel(false);
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
    }
}

