/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.serializer.lang;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.SerializationException;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.TypeSerializer;

public class ClassSerializer
implements TypeSerializer<Class<?>> {
    @Override
    public void write(Class<?> object, BufferOutput buffer, Serializer serializer) {
        buffer.writeUTF8(object.getName());
    }

    @Override
    public Class<?> read(Class<Class<?>> type, BufferInput buffer, Serializer serializer) {
        try {
            String className = buffer.readUTF8();
            return serializer.getClassLoader(className).loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException(e);
        }
    }
}

