/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.transport.netty;

import io.atomix.catalyst.buffer.Buffer;
import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.Bytes;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;

final class ByteBufInput
implements BufferInput<ByteBufInput> {
    ByteBuf buffer;

    ByteBufInput() {
    }

    ByteBufInput setByteBuf(ByteBuf buffer) {
        this.buffer = buffer;
        return this;
    }

    @Override
    public long remaining() {
        return this.buffer.readableBytes();
    }

    @Override
    public boolean hasRemaining() {
        return this.remaining() > 0L;
    }

    @Override
    public ByteBufInput skip(long bytes) {
        this.buffer.readerIndex(this.buffer.readerIndex() + (int)bytes);
        return this;
    }

    @Override
    public ByteBufInput read(Buffer buffer) {
        byte[] bytes = new byte[this.buffer.readableBytes()];
        this.buffer.readBytes(bytes);
        buffer.write(bytes);
        return this;
    }

    @Override
    public ByteBufInput read(Bytes bytes) {
        byte[] b = new byte[Math.min((int)bytes.size(), this.buffer.readableBytes())];
        this.buffer.readBytes(b);
        bytes.write(0L, b, 0L, (long)b.length);
        return this;
    }

    @Override
    public ByteBufInput read(byte[] bytes) {
        this.buffer.readBytes(bytes);
        return this;
    }

    @Override
    public ByteBufInput read(Bytes bytes, long dstOffset, long length) {
        byte[] b = new byte[Math.min((int)length, this.buffer.readableBytes())];
        this.buffer.readBytes(b);
        bytes.write(dstOffset, b, 0L, (long)b.length);
        return this;
    }

    @Override
    public ByteBufInput read(byte[] bytes, long offset, long length) {
        this.buffer.readBytes(bytes, (int)offset, (int)length);
        return this;
    }

    @Override
    public int readByte() {
        return this.buffer.readByte();
    }

    @Override
    public int readUnsignedByte() {
        return this.buffer.readUnsignedByte();
    }

    @Override
    public char readChar() {
        return this.buffer.readChar();
    }

    @Override
    public short readShort() {
        return this.buffer.readShort();
    }

    @Override
    public int readUnsignedShort() {
        return this.buffer.readUnsignedShort();
    }

    @Override
    public int readInt() {
        return this.buffer.readInt();
    }

    @Override
    public long readUnsignedInt() {
        return this.buffer.readUnsignedInt();
    }

    @Override
    public int readMedium() {
        return this.buffer.readMedium();
    }

    @Override
    public int readUnsignedMedium() {
        return this.buffer.readUnsignedMedium();
    }

    @Override
    public long readLong() {
        return this.buffer.readLong();
    }

    @Override
    public float readFloat() {
        return this.buffer.readFloat();
    }

    @Override
    public double readDouble() {
        return this.buffer.readDouble();
    }

    @Override
    public boolean readBoolean() {
        return this.buffer.readBoolean();
    }

    @Override
    public String readString() {
        return this.readUTF8();
    }

    @Override
    public String readUTF8() {
        byte nullByte = this.buffer.readByte();
        if (nullByte == 0) {
            return null;
        }
        byte[] bytes = new byte[this.buffer.readUnsignedShort()];
        this.buffer.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    public void close() {
    }
}

