/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.error.CopycatError;
import io.atomix.copycat.protocol.Response;
import io.atomix.copycat.protocol.SessionResponse;
import java.util.Collection;
import java.util.Objects;

public class KeepAliveResponse
extends SessionResponse {
    private Address leader;
    private Collection<Address> members;

    public static Builder builder() {
        return new Builder(new KeepAliveResponse());
    }

    public static Builder builder(KeepAliveResponse response) {
        return new Builder(response);
    }

    public Address leader() {
        return this.leader;
    }

    public Collection<Address> members() {
        return this.members;
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        this.status = Response.Status.forId(buffer.readByte());
        if (this.status == Response.Status.OK) {
            this.error = null;
            this.leader = (Address)serializer.readObject(buffer);
            this.members = (Collection)serializer.readObject(buffer);
        } else {
            this.error = CopycatError.forId(buffer.readByte());
            this.leader = (Address)serializer.readObject(buffer);
        }
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        buffer.writeByte(this.status.id());
        if (this.status == Response.Status.OK) {
            serializer.writeObject(this.leader, buffer);
            serializer.writeObject(this.members, buffer);
        } else {
            buffer.writeByte(this.error.id());
            serializer.writeObject(this.leader, buffer);
        }
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getClass(), this.status, this.leader, this.members});
    }

    public boolean equals(Object object) {
        if (object instanceof KeepAliveResponse) {
            KeepAliveResponse response = (KeepAliveResponse)object;
            return response.status == this.status && (response.leader == null && this.leader == null || response.leader != null && this.leader != null && response.leader.equals(this.leader)) && (response.members == null && this.members == null || response.members != null && this.members != null && response.members.equals(this.members));
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("%s[status=%s, error=%s, leader=%s, members=%s]", new Object[]{this.getClass().getSimpleName(), this.status, this.error, this.leader, this.members});
    }

    public static class Builder
    extends SessionResponse.Builder<Builder, KeepAliveResponse> {
        protected Builder(KeepAliveResponse response) {
            super(response);
        }

        public Builder withLeader(Address leader) {
            ((KeepAliveResponse)this.response).leader = leader;
            return this;
        }

        public Builder withMembers(Collection<Address> members) {
            ((KeepAliveResponse)this.response).members = Assert.notNull(members, "members");
            return this;
        }

        @Override
        public KeepAliveResponse build() {
            super.build();
            Assert.stateNot(((KeepAliveResponse)this.response).status == Response.Status.OK && ((KeepAliveResponse)this.response).members == null, "members cannot be null", new Object[0]);
            return (KeepAliveResponse)this.response;
        }
    }
}

