/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.Operation;
import io.atomix.copycat.protocol.SessionRequest;

public abstract class OperationRequest
extends SessionRequest {
    protected long sequence;

    public long sequence() {
        return this.sequence;
    }

    public abstract Operation operation();

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        super.readObject(buffer, serializer);
        this.sequence = buffer.readLong();
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        super.writeObject(buffer, serializer);
        buffer.writeLong(this.sequence);
    }

    public static abstract class Builder<T extends Builder<T, U>, U extends OperationRequest>
    extends SessionRequest.Builder<T, U> {
        protected Builder(U request) {
            super(request);
        }

        public T withSequence(long sequence) {
            ((OperationRequest)this.request).sequence = Assert.argNot(sequence, sequence < 0L, "sequence must be positive", new Object[0]);
            return (T)this;
        }

        @Override
        public U build() {
            super.build();
            Assert.stateNot(((OperationRequest)this.request).sequence < 0L, "sequence cannot be less than 0", new Object[0]);
            return (U)((OperationRequest)this.request);
        }
    }
}

