/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.error.CopycatError;
import io.atomix.copycat.protocol.Response;
import io.atomix.copycat.protocol.SessionResponse;
import java.util.Objects;

public class PublishResponse
extends SessionResponse {
    private long index;

    public static Builder builder() {
        return new Builder(new PublishResponse());
    }

    public static Builder builder(PublishResponse response) {
        return new Builder(response);
    }

    public long index() {
        return this.index;
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        this.status = Response.Status.forId(buffer.readByte());
        if (this.status == Response.Status.OK) {
            this.error = null;
        } else if (buffer.readBoolean()) {
            this.error = CopycatError.forId(buffer.readByte());
        }
        this.index = buffer.readLong();
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        buffer.writeByte(this.status.id());
        if (this.status == Response.Status.ERROR) {
            if (this.error != null) {
                buffer.writeBoolean(true).writeByte(this.error.id());
            } else {
                buffer.writeBoolean(false);
            }
        }
        buffer.writeLong(this.index);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getClass(), this.status});
    }

    public boolean equals(Object object) {
        if (object instanceof PublishResponse) {
            PublishResponse response = (PublishResponse)object;
            return response.status == this.status && response.index == this.index;
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("%s[status=%s, error=%s, index=%d]", new Object[]{this.getClass().getSimpleName(), this.status, this.error, this.index});
    }

    public static class Builder
    extends SessionResponse.Builder<Builder, PublishResponse> {
        protected Builder(PublishResponse response) {
            super(response);
        }

        public Builder withIndex(long index) {
            ((PublishResponse)this.response).index = Assert.argNot(index, index < 0L, "index cannot be less than 0", new Object[0]);
            return this;
        }

        @Override
        public PublishResponse build() {
            super.build();
            Assert.stateNot(((PublishResponse)this.response).index < 0L, "index cannot be less than 0", new Object[0]);
            return (PublishResponse)this.response;
        }
    }
}

