/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.copycat.error.CopycatError;
import io.atomix.copycat.protocol.Response;
import io.atomix.copycat.protocol.SessionResponse;
import java.util.Objects;

public class UnregisterResponse
extends SessionResponse {
    public static Builder builder() {
        return new Builder(new UnregisterResponse());
    }

    public static Builder builder(UnregisterResponse response) {
        return new Builder(response);
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        this.status = Response.Status.forId(buffer.readByte());
        this.error = this.status == Response.Status.OK ? null : CopycatError.forId(buffer.readByte());
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        buffer.writeByte(this.status.id());
        if (this.status == Response.Status.ERROR) {
            buffer.writeByte(this.error.id());
        }
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getClass(), this.status});
    }

    public boolean equals(Object object) {
        if (object instanceof UnregisterResponse) {
            UnregisterResponse response = (UnregisterResponse)object;
            return response.status == this.status;
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("%s[status=%s]", new Object[]{this.getClass().getSimpleName(), this.status});
    }

    public static class Builder
    extends SessionResponse.Builder<Builder, UnregisterResponse> {
        protected Builder(UnregisterResponse response) {
            super(response);
        }
    }
}

