/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.error.CopycatError;
import io.atomix.copycat.protocol.AbstractResponse;
import io.atomix.copycat.protocol.Response;
import java.util.Objects;

public class VoteResponse
extends AbstractResponse {
    private long term;
    private boolean voted;

    public static Builder builder() {
        return new Builder(new VoteResponse());
    }

    public static Builder builder(VoteResponse response) {
        return new Builder(response);
    }

    public long term() {
        return this.term;
    }

    public boolean voted() {
        return this.voted;
    }

    public void readObject(BufferInput buffer, Serializer serializer) {
        this.status = Response.Status.forId(buffer.readByte());
        if (this.status == Response.Status.OK) {
            this.error = null;
            this.term = buffer.readLong();
            this.voted = buffer.readBoolean();
        } else {
            this.error = CopycatError.forId(buffer.readByte());
        }
    }

    public void writeObject(BufferOutput buffer, Serializer serializer) {
        buffer.writeByte(this.status.id());
        if (this.status == Response.Status.OK) {
            buffer.writeLong(this.term).writeBoolean(this.voted);
        } else {
            buffer.writeByte(this.error.id());
        }
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getClass(), this.status, this.term, this.voted});
    }

    public boolean equals(Object object) {
        if (object instanceof VoteResponse) {
            VoteResponse response = (VoteResponse)object;
            return response.status == this.status && response.term == this.term && response.voted == this.voted;
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("%s[status=%s, term=%d, voted=%b]", new Object[]{this.getClass().getSimpleName(), this.status, this.term, this.voted});
    }

    public static class Builder
    extends AbstractResponse.Builder<Builder, VoteResponse> {
        protected Builder(VoteResponse response) {
            super(response);
        }

        public Builder withTerm(long term) {
            ((VoteResponse)this.response).term = Assert.argNot(term, term < 0L, "term cannot be negative", new Object[0]);
            return this;
        }

        public Builder withVoted(boolean voted) {
            ((VoteResponse)this.response).voted = voted;
            return this;
        }

        @Override
        public VoteResponse build() {
            super.build();
            if (((VoteResponse)this.response).status == Response.Status.OK) {
                Assert.stateNot(((VoteResponse)this.response).term < 0L, "term cannot be negative", new Object[0]);
            }
            return (VoteResponse)this.response;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.response);
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof Builder && ((VoteResponse)((Builder)object).response).equals(this.response);
        }

        @Override
        public String toString() {
            return String.format("%s[response=%s]", this.getClass().getCanonicalName(), this.response);
        }
    }
}

