/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.state;

import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Client;
import io.atomix.catalyst.transport.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class ConnectionManager {
    private final Client client;
    private final Map<Address, Connection> connections = new HashMap<Address, Connection>();

    public ConnectionManager(Client client) {
        this.client = client;
    }

    public CompletableFuture<Connection> getConnection(Address address) {
        Connection connection = this.connections.get(address);
        return connection == null ? this.createConnection(address) : CompletableFuture.completedFuture(connection);
    }

    public void resetConnection(Address address) {
        Connection connection = this.connections.remove(address);
        if (connection != null) {
            connection.close();
        }
    }

    private CompletableFuture<Connection> createConnection(Address address) {
        return this.client.connect(address).thenApply(connection -> {
            connection.closeListener(c -> {
                if (this.connections.get(address) == c) {
                    this.connections.remove(address);
                }
            });
            this.connections.put(address, (Connection)connection);
            return connection;
        });
    }

    public CompletableFuture<Void> close() {
        CompletableFuture[] futures = new CompletableFuture[this.connections.size()];
        int i = 0;
        for (Connection connection : this.connections.values()) {
            futures[i++] = connection.close();
        }
        return CompletableFuture.allOf(futures);
    }
}

