/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.state;

import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.server.state.ClusterState;
import io.atomix.copycat.server.state.ServerMember;
import io.atomix.copycat.server.storage.Log;

final class MemberState {
    private static final int MAX_APPENDS = 2;
    private final ServerMember member;
    private long term;
    private long configIndex;
    private long snapshotIndex;
    private long nextSnapshotIndex;
    private int nextSnapshotOffset;
    private long matchIndex;
    private long nextIndex;
    private long heartbeatTime;
    private long heartbeatStartTime;
    private int appending;
    private long appendTime;
    private boolean configuring;
    private boolean installing;
    private int failures;
    private final TimeBuffer timeBuffer = new TimeBuffer(8);

    public MemberState(ServerMember member, ClusterState cluster) {
        this.member = Assert.notNull(member, "member").setCluster(cluster);
    }

    void resetState(Log log) {
        this.nextSnapshotIndex = 0L;
        this.nextSnapshotOffset = 0;
        this.matchIndex = 0L;
        this.nextIndex = log.lastIndex() + 1L;
        this.heartbeatTime = 0L;
        this.heartbeatStartTime = 0L;
        this.appending = 0;
        this.timeBuffer.reset();
        this.configuring = false;
        this.installing = false;
        this.failures = 0;
    }

    public ServerMember getMember() {
        return this.member;
    }

    long getConfigTerm() {
        return this.term;
    }

    MemberState setConfigTerm(long term) {
        this.term = term;
        return this;
    }

    long getConfigIndex() {
        return this.configIndex;
    }

    MemberState setConfigIndex(long configIndex) {
        this.configIndex = configIndex;
        return this;
    }

    long getSnapshotIndex() {
        return this.snapshotIndex;
    }

    MemberState setSnapshotIndex(long snapshotIndex) {
        this.snapshotIndex = snapshotIndex;
        return this;
    }

    long getNextSnapshotIndex() {
        return this.nextSnapshotIndex;
    }

    MemberState setNextSnapshotIndex(long nextSnapshotIndex) {
        this.nextSnapshotIndex = nextSnapshotIndex;
        return this;
    }

    int getNextSnapshotOffset() {
        return this.nextSnapshotOffset;
    }

    MemberState setNextSnapshotOffset(int nextSnapshotOffset) {
        this.nextSnapshotOffset = nextSnapshotOffset;
        return this;
    }

    long getMatchIndex() {
        return this.matchIndex;
    }

    MemberState setMatchIndex(long matchIndex) {
        this.matchIndex = Assert.argNot(matchIndex, matchIndex < 0L, "matchIndex cannot be less than 0", new Object[0]);
        return this;
    }

    long getNextIndex() {
        return this.nextIndex;
    }

    MemberState setNextIndex(long nextIndex) {
        this.nextIndex = Assert.argNot(nextIndex, nextIndex <= 0L, "nextIndex cannot be less than or equal to 0", new Object[0]);
        return this;
    }

    boolean canAppend() {
        return this.appending == 0 || this.appending < 2 && System.nanoTime() - this.timeBuffer.average() / 2L >= this.appendTime;
    }

    MemberState startAppend() {
        ++this.appending;
        this.appendTime = System.nanoTime();
        return this;
    }

    MemberState completeAppend() {
        --this.appending;
        return this;
    }

    MemberState completeAppend(long time) {
        this.timeBuffer.record(time);
        return this.completeAppend();
    }

    boolean canConfigure() {
        return !this.configuring;
    }

    MemberState startConfigure() {
        this.configuring = true;
        return this;
    }

    MemberState completeConfigure() {
        this.configuring = false;
        return this;
    }

    boolean canInstall() {
        return !this.installing;
    }

    MemberState startInstall() {
        this.installing = true;
        return this;
    }

    MemberState completeInstall() {
        this.installing = false;
        return this;
    }

    long getHeartbeatTime() {
        return this.heartbeatTime;
    }

    MemberState setHeartbeatTime(long heartbeatTime) {
        this.heartbeatTime = heartbeatTime;
        return this;
    }

    long getHeartbeatStartTime() {
        return this.heartbeatStartTime;
    }

    MemberState setHeartbeatStartTime(long startTime) {
        this.heartbeatStartTime = startTime;
        return this;
    }

    int getFailureCount() {
        return this.failures;
    }

    int incrementFailureCount() {
        return ++this.failures;
    }

    MemberState resetFailureCount() {
        this.failures = 0;
        return this;
    }

    public String toString() {
        return this.member.serverAddress().toString();
    }

    private static class TimeBuffer {
        private final long[] buffer;
        private int position;

        public TimeBuffer(int size) {
            this.buffer = new long[size];
        }

        public void record(long time) {
            this.buffer[this.position++] = time;
            if (this.position >= this.buffer.length) {
                this.position = 0;
            }
        }

        public long average() {
            long total = 0L;
            for (long time : this.buffer) {
                if (time <= 0L) continue;
                total += time;
            }
            return total / (long)this.buffer.length;
        }

        public void reset() {
            for (int i = 0; i < this.buffer.length; ++i) {
                this.buffer[i] = 0L;
            }
            this.position = 0;
        }
    }
}

