/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.state;

import io.atomix.catalyst.transport.Connection;
import io.atomix.copycat.Query;
import io.atomix.copycat.error.CopycatError;
import io.atomix.copycat.error.CopycatException;
import io.atomix.copycat.protocol.ConnectRequest;
import io.atomix.copycat.protocol.ConnectResponse;
import io.atomix.copycat.protocol.OperationResponse;
import io.atomix.copycat.protocol.QueryRequest;
import io.atomix.copycat.protocol.QueryResponse;
import io.atomix.copycat.protocol.Response;
import io.atomix.copycat.server.CopycatServer;
import io.atomix.copycat.server.cluster.Member;
import io.atomix.copycat.server.protocol.AcceptRequest;
import io.atomix.copycat.server.protocol.AppendRequest;
import io.atomix.copycat.server.protocol.AppendResponse;
import io.atomix.copycat.server.protocol.InstallRequest;
import io.atomix.copycat.server.protocol.InstallResponse;
import io.atomix.copycat.server.state.AbstractState;
import io.atomix.copycat.server.state.ReserveState;
import io.atomix.copycat.server.state.ServerContext;
import io.atomix.copycat.server.state.ServerSessionContext;
import io.atomix.copycat.server.state.ServerStateMachine;
import io.atomix.copycat.server.storage.entry.ConnectEntry;
import io.atomix.copycat.server.storage.entry.Entry;
import io.atomix.copycat.server.storage.entry.QueryEntry;
import io.atomix.copycat.server.storage.snapshot.Snapshot;
import io.atomix.copycat.server.storage.snapshot.SnapshotWriter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;

class PassiveState
extends ReserveState {
    private Snapshot pendingSnapshot;
    private int nextSnapshotOffset;

    public PassiveState(ServerContext context) {
        super(context);
    }

    @Override
    public CopycatServer.State type() {
        return CopycatServer.State.PASSIVE;
    }

    @Override
    public CompletableFuture<AbstractState> open() {
        return ((CompletableFuture)super.open().thenRun(this::truncateUncommittedEntries)).thenApply(v -> this);
    }

    private void truncateUncommittedEntries() {
        if (this.type() == CopycatServer.State.PASSIVE) {
            this.context.getLog().truncate(Math.min(this.context.getCommitIndex(), this.context.getLog().lastIndex()));
        }
    }

    @Override
    protected CompletableFuture<ConnectResponse> connect(ConnectRequest request, Connection connection) {
        this.context.checkThread();
        this.logRequest(request);
        if (this.context.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((ConnectResponse.Builder)((ConnectResponse.Builder)ConnectResponse.builder().withStatus(Response.Status.ERROR)).withError(CopycatError.Type.NO_LEADER_ERROR)).build()));
        }
        this.context.getStateMachine().executor().context().sessions().registerConnection(request.client(), connection);
        AcceptRequest acceptRequest = AcceptRequest.builder().withClient(request.client()).withAddress(this.context.getCluster().member().serverAddress()).build();
        return ((CompletableFuture)((CompletableFuture)this.forward(acceptRequest).thenApply(acceptResponse -> ((ConnectResponse.Builder)ConnectResponse.builder().withStatus(Response.Status.OK)).withLeader(this.context.getLeader() != null ? this.context.getLeader().clientAddress() : null).withMembers(this.context.getCluster().members().stream().map(Member::clientAddress).filter(m -> m != null).collect(Collectors.toList())).build())).exceptionally(error -> ((ConnectResponse.Builder)((ConnectResponse.Builder)ConnectResponse.builder().withStatus(Response.Status.ERROR)).withError(CopycatError.Type.NO_LEADER_ERROR)).build())).thenApply(this::logResponse);
    }

    @Override
    protected CompletableFuture<AppendResponse> append(AppendRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        this.updateTermAndLeader(request.term(), request.leader());
        return CompletableFuture.completedFuture(this.logResponse(this.handleAppend(request)));
    }

    protected AppendResponse handleAppend(AppendRequest request) {
        if (request.term() < this.context.getTerm()) {
            this.LOGGER.debug("{} - Rejected {}: request term is less than the current term ({})", new Object[]{this.context.getCluster().member().address(), request, this.context.getTerm()});
            return ((AppendResponse.Builder)AppendResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withSucceeded(false).withLogIndex(this.context.getLog().lastIndex()).build();
        }
        return this.checkGlobalIndex(request);
    }

    protected AppendResponse checkGlobalIndex(AppendRequest request) {
        long currentGlobalIndex = this.context.getGlobalIndex();
        long nextGlobalIndex = request.globalIndex();
        if (currentGlobalIndex > 0L && nextGlobalIndex > currentGlobalIndex && nextGlobalIndex > this.context.getLog().lastIndex()) {
            this.context.setGlobalIndex(nextGlobalIndex);
            this.context.reset();
        }
        if (request.logIndex() != 0L) {
            return this.checkPreviousEntry(request);
        }
        return this.appendEntries(request);
    }

    protected AppendResponse checkPreviousEntry(AppendRequest request) {
        if (request.logIndex() != 0L && this.context.getLog().isEmpty()) {
            this.LOGGER.debug("{} - Rejected {}: Previous index ({}) is greater than the local log's last index ({})", new Object[]{this.context.getCluster().member().address(), request, request.logIndex(), this.context.getLog().lastIndex()});
            return ((AppendResponse.Builder)AppendResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withSucceeded(false).withLogIndex(this.context.getLog().lastIndex()).build();
        }
        if (request.logIndex() != 0L && this.context.getLog().lastIndex() != 0L && request.logIndex() > this.context.getLog().lastIndex()) {
            this.LOGGER.debug("{} - Rejected {}: Previous index ({}) is greater than the local log's last index ({})", new Object[]{this.context.getCluster().member().address(), request, request.logIndex(), this.context.getLog().lastIndex()});
            return ((AppendResponse.Builder)AppendResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withSucceeded(false).withLogIndex(this.context.getLog().lastIndex()).build();
        }
        return this.appendEntries(request);
    }

    protected AppendResponse appendEntries(AppendRequest request) {
        long commitIndex = Math.max(this.context.getCommitIndex(), request.commitIndex());
        for (Entry entry : request.entries()) {
            if (this.context.getLog().lastIndex() < entry.getIndex() && entry.getIndex() <= commitIndex) {
                this.context.getLog().skip(entry.getIndex() - this.context.getLog().lastIndex() - 1L).append(entry);
                this.LOGGER.debug("{} - Appended {} to log at index {}", new Object[]{this.context.getCluster().member().address(), entry, entry.getIndex()});
            }
            if (!(entry instanceof ConnectEntry)) continue;
            ConnectEntry connectEntry = (ConnectEntry)entry;
            this.context.getStateMachine().executor().context().sessions().registerAddress(connectEntry.getClient(), connectEntry.getAddress());
        }
        this.context.setCommitIndex(commitIndex);
        this.context.setGlobalIndex(request.globalIndex());
        this.context.getStateMachine().applyAll(this.context.getCommitIndex());
        return ((AppendResponse.Builder)AppendResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withSucceeded(true).withLogIndex(this.context.getLog().lastIndex()).build();
    }

    @Override
    protected CompletableFuture<QueryResponse> query(QueryRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        if (request.query().consistency() == Query.ConsistencyLevel.SEQUENTIAL) {
            if (this.context.getStateMachine().getLastApplied() < request.session()) {
                this.LOGGER.debug("{} - State out of sync, forwarding query to leader");
                return this.queryForward(request);
            }
            if (this.context.getLog().lastIndex() < this.context.getCommitIndex()) {
                this.LOGGER.debug("{} - State out of sync, forwarding query to leader");
                return this.queryForward(request);
            }
            QueryEntry entry = ((QueryEntry)((QueryEntry)((QueryEntry)((QueryEntry)((QueryEntry)this.context.getLog().create(QueryEntry.class).setIndex(request.index())).setTerm(this.context.getTerm())).setTimestamp(System.currentTimeMillis())).setSession(request.session())).setSequence(request.sequence())).setQuery(request.query());
            return this.queryLocal(entry);
        }
        return this.queryForward(request);
    }

    private CompletableFuture<QueryResponse> queryForward(QueryRequest request) {
        if (this.context.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((QueryResponse.Builder)((QueryResponse.Builder)QueryResponse.builder().withStatus(Response.Status.ERROR)).withError(CopycatError.Type.NO_LEADER_ERROR)).build()));
        }
        this.LOGGER.debug("{} - Forwarded {}", (Object)this.context.getCluster().member().address(), (Object)request);
        return ((CompletableFuture)this.forward(request).exceptionally(error -> (QueryResponse)((QueryResponse.Builder)((QueryResponse.Builder)QueryResponse.builder().withStatus(Response.Status.ERROR)).withError(CopycatError.Type.NO_LEADER_ERROR)).build())).thenApply(this::logResponse);
    }

    protected CompletableFuture<QueryResponse> queryLocal(QueryEntry entry) {
        CompletableFuture<QueryResponse> future = new CompletableFuture<QueryResponse>();
        this.sequenceQuery(entry, future);
        return future;
    }

    private void sequenceQuery(QueryEntry entry, CompletableFuture<QueryResponse> future) {
        ServerSessionContext session = this.context.getStateMachine().executor().context().sessions().getSession(entry.getSession());
        if (session == null) {
            future.complete((QueryResponse)this.logResponse(((QueryResponse.Builder)((QueryResponse.Builder)QueryResponse.builder().withStatus(Response.Status.ERROR)).withError(CopycatError.Type.UNKNOWN_SESSION_ERROR)).build()));
        } else {
            this.sequenceQuery(entry, session, future);
        }
    }

    private void sequenceQuery(QueryEntry entry, ServerSessionContext session, CompletableFuture<QueryResponse> future) {
        if (entry.getSequence() > session.getCommandSequence()) {
            session.registerSequenceQuery(entry.getSequence(), () -> this.indexQuery(entry, future));
        } else {
            this.indexQuery(entry, future);
        }
    }

    private void indexQuery(QueryEntry entry, CompletableFuture<QueryResponse> future) {
        ServerSessionContext session = this.context.getStateMachine().executor().context().sessions().getSession(entry.getSession());
        if (session == null) {
            future.complete((QueryResponse)this.logResponse(((QueryResponse.Builder)((QueryResponse.Builder)QueryResponse.builder().withStatus(Response.Status.ERROR)).withError(CopycatError.Type.UNKNOWN_SESSION_ERROR)).build()));
        } else {
            this.indexQuery(entry, session, future);
        }
    }

    private void indexQuery(QueryEntry entry, ServerSessionContext session, CompletableFuture<QueryResponse> future) {
        if (entry.getIndex() > session.getLastApplied()) {
            session.registerIndexQuery(entry.getIndex(), () -> this.applyQuery(entry, future));
        } else {
            this.applyQuery(entry, future);
        }
    }

    protected CompletableFuture<QueryResponse> applyQuery(QueryEntry entry, CompletableFuture<QueryResponse> future) {
        this.context.getStateMachine().apply((Entry)entry).whenComplete((result, error) -> {
            this.completeOperation((ServerStateMachine.Result)result, QueryResponse.builder(), (Throwable)error, future);
            entry.release();
        });
        return future;
    }

    protected <T extends OperationResponse> void completeOperation(ServerStateMachine.Result result, OperationResponse.Builder<?, T> builder, Throwable error, CompletableFuture<T> future) {
        if (this.isOpen()) {
            if (result != null) {
                builder.withIndex(result.index);
                builder.withEventIndex(result.eventIndex);
                if (result.result instanceof Exception) {
                    error = (Exception)result.result;
                }
            }
            if (error == null) {
                future.complete(this.logResponse(((OperationResponse.Builder)((OperationResponse.Builder)builder.withStatus(Response.Status.OK)).withResult(result.result)).build()));
            } else if (error instanceof CompletionException && error.getCause() instanceof CopycatException) {
                future.complete(this.logResponse(((OperationResponse.Builder)((OperationResponse.Builder)builder.withStatus(Response.Status.ERROR)).withError(((CopycatException)error.getCause()).getType())).build()));
            } else if (error instanceof CopycatException) {
                future.complete(this.logResponse(((OperationResponse.Builder)((OperationResponse.Builder)builder.withStatus(Response.Status.ERROR)).withError(((CopycatException)error).getType())).build()));
            } else {
                future.complete(this.logResponse(((OperationResponse.Builder)((OperationResponse.Builder)builder.withStatus(Response.Status.ERROR)).withError(CopycatError.Type.INTERNAL_ERROR)).build()));
            }
        }
    }

    @Override
    protected CompletableFuture<InstallResponse> install(InstallRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        this.updateTermAndLeader(request.term(), request.leader());
        if (request.term() < this.context.getTerm()) {
            return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)((InstallResponse.Builder)InstallResponse.builder().withStatus(Response.Status.ERROR)).withError(CopycatError.Type.ILLEGAL_MEMBER_STATE_ERROR)).build()));
        }
        if (this.pendingSnapshot != null && request.index() != this.pendingSnapshot.index()) {
            this.pendingSnapshot.close();
            this.pendingSnapshot.delete();
            this.pendingSnapshot = null;
            this.nextSnapshotOffset = 0;
        }
        if (this.pendingSnapshot == null) {
            if (request.offset() > 0) {
                return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)((InstallResponse.Builder)InstallResponse.builder().withStatus(Response.Status.ERROR)).withError(CopycatError.Type.ILLEGAL_MEMBER_STATE_ERROR)).build()));
            }
            this.pendingSnapshot = this.context.getSnapshotStore().createSnapshot(request.index());
            this.nextSnapshotOffset = 0;
        }
        if (request.offset() > this.nextSnapshotOffset) {
            return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)((InstallResponse.Builder)InstallResponse.builder().withStatus(Response.Status.ERROR)).withError(CopycatError.Type.ILLEGAL_MEMBER_STATE_ERROR)).build()));
        }
        try (SnapshotWriter writer = this.pendingSnapshot.writer();){
            writer.write(request.data());
        }
        if (request.complete()) {
            this.pendingSnapshot.complete();
            this.pendingSnapshot = null;
            this.nextSnapshotOffset = 0;
        } else {
            ++this.nextSnapshotOffset;
        }
        return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)InstallResponse.builder().withStatus(Response.Status.OK)).build()));
    }

    @Override
    public CompletableFuture<Void> close() {
        if (this.pendingSnapshot != null) {
            this.pendingSnapshot.close();
            this.pendingSnapshot.delete();
            this.pendingSnapshot = null;
        }
        return super.close();
    }
}

