/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.entry;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.reference.ReferenceManager;
import io.atomix.copycat.server.cluster.Member;
import io.atomix.copycat.server.storage.compaction.Compaction;
import io.atomix.copycat.server.storage.entry.Entry;
import io.atomix.copycat.server.storage.entry.TimestampedEntry;
import java.util.Collection;

public class ConfigurationEntry
extends TimestampedEntry<ConfigurationEntry> {
    private Collection<Member> members;

    public ConfigurationEntry() {
    }

    public ConfigurationEntry(ReferenceManager<Entry<?>> referenceManager) {
        super(referenceManager);
    }

    @Override
    public Compaction.Mode getCompactionMode() {
        return Compaction.Mode.FULL;
    }

    public Collection<Member> getMembers() {
        return this.members;
    }

    public ConfigurationEntry setMembers(Collection<Member> members) {
        this.members = Assert.notNull(members, "members");
        return this;
    }

    @Override
    public void writeObject(BufferOutput buffer, Serializer serializer) {
        super.writeObject(buffer, serializer);
        serializer.writeObject(this.members, buffer);
    }

    @Override
    public void readObject(BufferInput buffer, Serializer serializer) {
        super.readObject(buffer, serializer);
        this.members = (Collection)serializer.readObject(buffer);
    }

    @Override
    public String toString() {
        return String.format("%s[index=%d, term=%d, timestamp=%d, members=%s]", this.getClass().getSimpleName(), this.getIndex(), this.getTerm(), this.getTimestamp(), this.members);
    }
}

