/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.group.election.internal;

import io.atomix.catalyst.concurrent.Listener;
import io.atomix.catalyst.concurrent.Listeners;
import io.atomix.catalyst.util.Assert;
import io.atomix.group.GroupMember;
import io.atomix.group.election.Election;
import io.atomix.group.election.Term;
import io.atomix.group.election.internal.GroupTerm;
import io.atomix.group.internal.MembershipGroup;
import java.util.function.Consumer;

public class GroupElection
implements Election {
    private final MembershipGroup group;
    private final Listeners<Term> electionListeners = new Listeners();
    private volatile GroupTerm term = new GroupTerm(0L);

    public GroupElection(MembershipGroup group) {
        this.group = Assert.notNull(group, "group");
    }

    @Override
    public Term term() {
        return this.term;
    }

    @Override
    public synchronized Listener<Term> onElection(Consumer<Term> callback) {
        Listener<Term> listener = this.electionListeners.add(callback);
        if (this.term != null && this.term.leader() != null) {
            listener.accept(this.term);
        }
        return listener;
    }

    public synchronized void onTerm(long term) {
        this.term = new GroupTerm(term);
    }

    public synchronized void onElection(GroupMember leader) {
        this.term.setLeader(leader);
        this.electionListeners.accept(this.term);
    }

    public void onResign() {
        this.term.setLeader(null);
    }
}

