/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.manager.internal;

import io.atomix.copycat.Operation;
import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.session.ServerSession;
import io.atomix.manager.internal.ResourceManagerCommitPool;
import io.atomix.manager.resource.internal.InstanceOperation;
import java.time.Instant;

class ResourceManagerCommit
implements Commit {
    private final ResourceManagerCommitPool pool;
    private Commit<InstanceOperation<?, ?>> commit;
    private ServerSession session;

    public ResourceManagerCommit(ResourceManagerCommitPool pool) {
        this.pool = pool;
    }

    void reset(Commit<InstanceOperation<?, ?>> commit, ServerSession session) {
        this.commit = commit;
        this.session = session;
    }

    @Override
    public long index() {
        return this.commit.index();
    }

    @Override
    public ServerSession session() {
        return this.session;
    }

    @Override
    public Instant time() {
        return this.commit.time();
    }

    public Class<?> type() {
        return this.commit.operation().operation().getClass();
    }

    public Operation<?> operation() {
        return this.commit.operation().operation();
    }

    @Override
    public Commit acquire() {
        this.commit.acquire();
        return this;
    }

    @Override
    public boolean release() {
        if (this.commit.release()) {
            this.pool.release(this);
            return true;
        }
        return false;
    }

    @Override
    public int references() {
        return this.commit.references();
    }

    @Override
    public void close() {
        this.commit.close();
        this.pool.release(this);
    }

    public String toString() {
        return String.format("%s[index=%d, session=%s, time=%s, operation=%s]", this.getClass().getSimpleName(), this.index(), this.session(), this.time(), this.operation());
    }
}

