/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.manager.resource.internal;

import io.atomix.catalyst.util.Assert;
import io.atomix.resource.ResourceType;
import java.util.Properties;
import java.util.function.Consumer;

public final class ResourceInstance
implements AutoCloseable {
    private final String key;
    private final ResourceType type;
    private final Properties config;
    private final Consumer<ResourceInstance> closer;

    public ResourceInstance(String key, ResourceType type, Properties config, Consumer<ResourceInstance> closer) {
        this.key = Assert.notNull(key, "key");
        this.type = Assert.notNull(type, "type");
        this.config = Assert.notNull(config, "config");
        this.closer = Assert.notNull(closer, "closer");
    }

    public String key() {
        return this.key;
    }

    public ResourceType type() {
        return this.type;
    }

    public Properties config() {
        return this.config;
    }

    @Override
    public void close() {
        this.closer.accept(this);
    }

    public String toString() {
        return String.format("%s[key=%s, type=%s]", this.getClass().getSimpleName(), this.key, this.type);
    }
}

