/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.collections.internal;

import io.atomix.catalyst.concurrent.Scheduled;
import io.atomix.collections.DistributedSet;
import io.atomix.collections.internal.SetCommands;
import io.atomix.copycat.server.Commit;
import io.atomix.resource.ResourceStateMachine;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class SetState
extends ResourceStateMachine {
    private final Map<Object, Value> map = new HashMap<Object, Value>();

    public SetState(Properties properties) {
        super(properties);
    }

    public boolean contains(Commit<SetCommands.Contains> commit) {
        try {
            boolean bl = this.map.containsKey(((SetCommands.Contains)commit.operation()).value());
            return bl;
        }
        finally {
            commit.close();
        }
    }

    public boolean add(Commit<SetCommands.Add> commit) {
        try {
            Value value = this.map.get(((SetCommands.Add)commit.operation()).value());
            if (value == null) {
                Scheduled timer = ((SetCommands.Add)commit.operation()).ttl() > 0L ? this.executor.schedule(Duration.ofMillis(((SetCommands.Add)commit.operation()).ttl()), () -> this.map.remove(((SetCommands.Add)commit.operation()).value()).commit.close()) : null;
                this.map.put(((SetCommands.Add)commit.operation()).value(), new Value(commit, timer));
                this.notify(new DistributedSet.ValueEvent<Object>(DistributedSet.Events.ADD, ((SetCommands.Add)commit.operation()).value()));
            } else {
                commit.close();
            }
        }
        catch (Exception e) {
            commit.close();
            throw e;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Commit<SetCommands.Remove> commit) {
        try {
            Value value = this.map.remove(((SetCommands.Remove)commit.operation()).value());
            if (value != null) {
                try {
                    if (value.timer != null) {
                        value.timer.cancel();
                    }
                    this.notify(new DistributedSet.ValueEvent<Object>(DistributedSet.Events.REMOVE, ((SetCommands.Remove)commit.operation()).value()));
                    boolean bl = true;
                    return bl;
                }
                finally {
                    value.commit.close();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            commit.close();
        }
    }

    public int size(Commit<SetCommands.Size> commit) {
        try {
            int n = this.map.size();
            return n;
        }
        finally {
            commit.close();
        }
    }

    public boolean isEmpty(Commit<SetCommands.IsEmpty> commit) {
        try {
            boolean bl = this.map.isEmpty();
            return bl;
        }
        finally {
            commit.close();
        }
    }

    public Set<Object> iterator(Commit<SetCommands.Iterator<Object>> commit) {
        try {
            HashSet<Object> hashSet = new HashSet<Object>(this.map.keySet());
            return hashSet;
        }
        finally {
            commit.close();
        }
    }

    public void clear(Commit<SetCommands.Clear> commit) {
        try {
            this.delete();
        }
        finally {
            commit.close();
        }
    }

    public void delete() {
        Iterator<Map.Entry<Object, Value>> iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Value> entry = iterator.next();
            Value value = entry.getValue();
            if (value.timer != null) {
                value.timer.cancel();
            }
            value.commit.close();
            iterator.remove();
        }
    }

    private static class Value {
        private final Commit<? extends SetCommands.TtlCommand> commit;
        private final Scheduled timer;

        private Value(Commit<? extends SetCommands.TtlCommand> commit, Scheduled timer) {
            this.commit = commit;
            this.timer = timer;
        }
    }
}

