/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ModuleRef;
import io.github.classgraph.utils.FileUtils;
import io.github.classgraph.utils.InputStreamOrByteBufferAdapter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;

public abstract class Resource
implements Closeable,
Comparable<Resource> {
    protected InputStream inputStream;
    protected ByteBuffer byteBuffer;
    protected long length = -1L;
    private String toString;

    protected InputStream byteBufferToInputStream() {
        return this.inputStream == null ? (this.inputStream = FileUtils.byteBufferToInputStream(this.byteBuffer)) : this.inputStream;
    }

    protected ByteBuffer inputStreamToByteBuffer() throws IOException {
        return this.byteBuffer == null ? (this.byteBuffer = ByteBuffer.wrap(this.inputStreamToByteArray())) : this.byteBuffer;
    }

    protected byte[] inputStreamToByteArray() throws IOException {
        return FileUtils.readAllBytesAsArray(this.inputStream, this.length, null);
    }

    protected byte[] byteBufferToByteArray() {
        if (this.byteBuffer.hasArray()) {
            return this.byteBuffer.array();
        }
        byte[] byteArray = new byte[this.byteBuffer.remaining()];
        this.byteBuffer.get(byteArray);
        return byteArray;
    }

    public abstract String getPath();

    public abstract String getPathRelativeToClasspathElement();

    public abstract URL getURL();

    public abstract URL getClasspathElementURL();

    public abstract File getClasspathElementFile();

    public abstract ModuleRef getModuleRef();

    public abstract InputStream open() throws IOException;

    public abstract ByteBuffer read() throws IOException;

    public abstract byte[] load() throws IOException;

    abstract InputStreamOrByteBufferAdapter openOrRead() throws IOException;

    public long getLength() {
        return this.length;
    }

    protected abstract String toStringImpl();

    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        this.toString = this.toStringImpl();
        return this.toString;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Resource)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    @Override
    public int compareTo(Resource o) {
        return this.toString().compareTo(o.toString());
    }

    @Override
    public abstract void close();

    protected class InputStreamResourceCloser
    extends InputStream {
        private InputStream inputStream;
        private Resource parentResource;

        protected InputStreamResourceCloser(Resource parentResource, InputStream inputStream) throws IOException {
            if (inputStream == null) {
                throw new IOException("InputStream cannot be null");
            }
            this.inputStream = inputStream;
            this.parentResource = parentResource;
        }

        @Override
        public int read() throws IOException {
            if (this.inputStream == null) {
                throw new IOException("InputStream is not open");
            }
            return this.inputStream.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.inputStream == null) {
                throw new IOException("InputStream is not open");
            }
            return this.inputStream.read(b, off, len);
        }

        @Override
        public int read(byte[] b) throws IOException {
            if (this.inputStream == null) {
                throw new IOException("InputStream is not open");
            }
            return this.inputStream.read(b);
        }

        @Override
        public int available() throws IOException {
            if (this.inputStream == null) {
                throw new IOException("InputStream is not open");
            }
            return this.inputStream.available();
        }

        @Override
        public long skip(long n) throws IOException {
            if (this.inputStream == null) {
                throw new IOException("InputStream is not open");
            }
            return this.inputStream.skip(n);
        }

        @Override
        public boolean markSupported() {
            return this.inputStream.markSupported();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.inputStream.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            if (this.inputStream == null) {
                throw new IOException("InputStream is not open");
            }
            this.inputStream.reset();
        }

        @Override
        public void close() throws IOException {
            if (this.inputStream == null) {
                throw new IOException("InputStream is not open");
            }
            this.inputStream.close();
            this.inputStream = null;
            this.parentResource.close();
            this.parentResource = null;
        }
    }
}

