/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.log.impl;

import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.MemberId;
import io.atomix.primitive.Replication;
import io.atomix.primitive.partition.GroupMember;
import io.atomix.primitive.partition.ManagedMemberGroupService;
import io.atomix.primitive.partition.MemberGroup;
import io.atomix.primitive.partition.PrimaryElection;
import io.atomix.primitive.partition.PrimaryElectionEventListener;
import io.atomix.primitive.partition.PrimaryTerm;
import io.atomix.protocols.log.DistributedLogServer;
import io.atomix.protocols.log.protocol.AppendRequest;
import io.atomix.protocols.log.protocol.AppendResponse;
import io.atomix.protocols.log.protocol.BackupRequest;
import io.atomix.protocols.log.protocol.BackupResponse;
import io.atomix.protocols.log.protocol.ConsumeRequest;
import io.atomix.protocols.log.protocol.ConsumeResponse;
import io.atomix.protocols.log.protocol.LogEntry;
import io.atomix.protocols.log.protocol.LogResponse;
import io.atomix.protocols.log.protocol.LogServerProtocol;
import io.atomix.protocols.log.protocol.ResetRequest;
import io.atomix.protocols.log.roles.FollowerRole;
import io.atomix.protocols.log.roles.LeaderRole;
import io.atomix.protocols.log.roles.LogServerRole;
import io.atomix.protocols.log.roles.NoneRole;
import io.atomix.storage.journal.JournalReader;
import io.atomix.storage.journal.JournalSegment;
import io.atomix.storage.journal.JournalWriter;
import io.atomix.storage.journal.SegmentedJournal;
import io.atomix.utils.Managed;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.concurrent.Scheduled;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.concurrent.ThreadContextFactory;
import io.atomix.utils.event.EventListener;
import io.atomix.utils.logging.ContextualLogger;
import io.atomix.utils.logging.LoggerContext;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedLogServerContext
implements Managed<Void> {
    private final Logger log;
    private final String serverName;
    private final MemberId memberId;
    private final ClusterMembershipService clusterMembershipService;
    private final ManagedMemberGroupService memberGroupService;
    private final LogServerProtocol protocol;
    private final int replicationFactor;
    private final Replication replicationStrategy;
    private final ThreadContextFactory threadContextFactory;
    private final ThreadContext threadContext;
    private final boolean closeOnStop;
    private final PrimaryElection primaryElection;
    private MemberId leader;
    private List<MemberId> followers;
    private LogServerRole role;
    private long currentTerm;
    private long commitIndex;
    private final SegmentedJournal<LogEntry> journal;
    private final JournalWriter<LogEntry> writer;
    private final JournalReader<LogEntry> reader;
    private final long maxLogSize;
    private final Duration maxLogAge;
    private Scheduled compactTimer;
    private final PrimaryElectionEventListener primaryElectionListener = event -> this.changeRole(event.term());
    private final AtomicBoolean started = new AtomicBoolean();

    public DistributedLogServerContext(String serverName, ClusterMembershipService clusterMembershipService, ManagedMemberGroupService memberGroupService, LogServerProtocol protocol, PrimaryElection primaryElection, int replicationFactor, Replication replicationStrategy, SegmentedJournal<LogEntry> journal, long maxLogSize, Duration maxLogAge, ThreadContextFactory threadContextFactory, boolean closeOnStop) {
        this.serverName = serverName;
        this.memberId = clusterMembershipService.getLocalMember().id();
        this.clusterMembershipService = clusterMembershipService;
        this.memberGroupService = memberGroupService;
        this.protocol = protocol;
        this.replicationFactor = replicationFactor;
        this.replicationStrategy = replicationStrategy;
        this.threadContextFactory = threadContextFactory;
        this.threadContext = threadContextFactory.createContext();
        this.closeOnStop = closeOnStop;
        this.journal = journal;
        this.writer = journal.writer();
        this.reader = journal.openReader(1L);
        this.maxLogSize = maxLogSize;
        this.maxLogAge = maxLogAge;
        this.primaryElection = primaryElection;
        this.log = new ContextualLogger(LoggerFactory.getLogger(this.getClass()), LoggerContext.builder(this.getClass()).addValue((Object)serverName).build());
    }

    public String serverName() {
        return this.serverName;
    }

    public MemberId memberId() {
        return this.memberId;
    }

    public LogServerProtocol protocol() {
        return this.protocol;
    }

    public SegmentedJournal<LogEntry> journal() {
        return this.journal;
    }

    public JournalWriter<LogEntry> writer() {
        return this.writer;
    }

    public JournalReader<LogEntry> reader() {
        return this.reader;
    }

    public int replicationFactor() {
        return this.replicationFactor;
    }

    public Replication replicationStrategy() {
        return this.replicationStrategy;
    }

    public ThreadContext threadContext() {
        return this.threadContext;
    }

    public DistributedLogServer.Role getRole() {
        return Objects.equals(((PrimaryTerm)Futures.get((Future)this.primaryElection.getTerm())).primary().memberId(), this.clusterMembershipService.getLocalMember().id()) ? DistributedLogServer.Role.LEADER : DistributedLogServer.Role.FOLLOWER;
    }

    public MemberId leader() {
        return this.leader;
    }

    public List<MemberId> followers() {
        return this.followers;
    }

    public long currentTerm() {
        return this.currentTerm;
    }

    public void resetTerm(long term, MemberId leader) {
        this.currentTerm = term;
        this.leader = leader;
    }

    public long setCommitIndex(long commitIndex) {
        this.commitIndex = Math.max(this.commitIndex, commitIndex);
        this.writer.commit(this.commitIndex);
        return this.commitIndex;
    }

    public long getCommitIndex() {
        return this.commitIndex;
    }

    public void compact() {
        this.compactBySize();
        this.compactByAge();
    }

    private void compactBySize() {
        if (this.maxLogSize > 0L && this.journal.size() > this.maxLogSize) {
            JournalSegment compactSegment = null;
            Long compactIndex = null;
            for (JournalSegment segment : this.journal.segments()) {
                Collection remainingSegments = this.journal.segments(segment.lastIndex() + 1L);
                long remainingSize = remainingSegments.stream().mapToLong(JournalSegment::size).sum();
                if (remainingSize > this.maxLogSize) {
                    this.log.debug("Found outsize journal segment {}", (Object)segment.file().file());
                    compactSegment = segment;
                    continue;
                }
                if (compactSegment == null) continue;
                compactIndex = segment.index();
                break;
            }
            if (compactIndex != null) {
                this.log.info("Compacting journal by size up to {}", compactIndex);
                this.journal.compact(compactIndex.longValue());
            }
        }
    }

    private void compactByAge() {
        if (this.maxLogAge != null) {
            long currentTime = System.currentTimeMillis();
            JournalSegment compactSegment = null;
            Long compactIndex = null;
            for (JournalSegment segment : this.journal.segments()) {
                if (currentTime - segment.descriptor().updated() > this.maxLogAge.toMillis()) {
                    this.log.debug("Found expired journal segment {}", (Object)segment.file().file());
                    compactSegment = segment;
                    continue;
                }
                if (compactSegment == null) continue;
                compactIndex = segment.index();
                break;
            }
            if (compactIndex != null) {
                this.log.info("Compacting journal by age up to {}", compactIndex);
                this.journal.compact(compactIndex.longValue());
            }
        }
    }

    public CompletableFuture<Void> start() {
        this.registerListeners();
        this.compactTimer = this.threadContext.schedule(Duration.ofSeconds(30L), this::compact);
        return ((CompletableFuture)this.memberGroupService.start().thenComposeAsync(v -> {
            MemberGroup group = this.memberGroupService.getMemberGroup(this.clusterMembershipService.getLocalMember());
            this.primaryElection.addListener((EventListener)this.primaryElectionListener);
            if (group != null) {
                return this.primaryElection.enter(new GroupMember(this.clusterMembershipService.getLocalMember().id(), group.id())).thenApply(term -> {
                    this.changeRole((PrimaryTerm)term);
                    return null;
                });
            }
            return CompletableFuture.completedFuture(null);
        }, (Executor)this.threadContext)).thenApply(v -> {
            this.started.set(true);
            return null;
        });
    }

    private void changeRole(PrimaryTerm term) {
        this.threadContext.execute(() -> {
            if (term.term() >= this.currentTerm) {
                this.log.debug("{} - Term changed: {}", (Object)this.memberId, (Object)term);
                this.currentTerm = term.term();
                this.leader = term.primary() != null ? term.primary().memberId() : null;
                this.followers = term.backups(this.replicationFactor - 1).stream().map(GroupMember::memberId).collect(Collectors.toList());
                if (Objects.equals(this.leader, this.clusterMembershipService.getLocalMember().id())) {
                    if (this.role == null) {
                        this.role = new LeaderRole(this);
                        this.log.debug("{} transitioning to {}", (Object)this.clusterMembershipService.getLocalMember().id(), (Object)DistributedLogServer.Role.LEADER);
                    } else if (this.role.role() != DistributedLogServer.Role.LEADER) {
                        this.role.close();
                        this.role = new LeaderRole(this);
                        this.log.debug("{} transitioning to {}", (Object)this.clusterMembershipService.getLocalMember().id(), (Object)DistributedLogServer.Role.LEADER);
                    }
                } else if (this.followers.contains(this.clusterMembershipService.getLocalMember().id())) {
                    if (this.role == null) {
                        this.role = new FollowerRole(this);
                        this.log.debug("{} transitioning to {}", (Object)this.clusterMembershipService.getLocalMember().id(), (Object)DistributedLogServer.Role.FOLLOWER);
                    } else if (this.role.role() != DistributedLogServer.Role.FOLLOWER) {
                        this.role.close();
                        this.role = new FollowerRole(this);
                        this.log.debug("{} transitioning to {}", (Object)this.clusterMembershipService.getLocalMember().id(), (Object)DistributedLogServer.Role.FOLLOWER);
                    }
                } else if (this.role == null) {
                    this.role = new NoneRole(this);
                    this.log.debug("{} transitioning to {}", (Object)this.clusterMembershipService.getLocalMember().id(), (Object)DistributedLogServer.Role.NONE);
                } else if (this.role.role() != DistributedLogServer.Role.NONE) {
                    this.role.close();
                    this.role = new NoneRole(this);
                    this.log.debug("{} transitioning to {}", (Object)this.clusterMembershipService.getLocalMember().id(), (Object)DistributedLogServer.Role.NONE);
                }
            }
        });
    }

    private CompletableFuture<AppendResponse> append(AppendRequest request) {
        return this.runOnContext(() -> this.role.append(request));
    }

    private CompletableFuture<BackupResponse> backup(BackupRequest request) {
        return this.runOnContext(() -> this.role.backup(request));
    }

    private CompletableFuture<ConsumeResponse> consume(ConsumeRequest request) {
        return this.runOnContext(() -> this.role.consume(request));
    }

    private void reset(ResetRequest request) {
        this.role.reset(request);
    }

    private <R extends LogResponse> CompletableFuture<R> runOnContext(Supplier<CompletableFuture<R>> function) {
        CompletableFuture future = new CompletableFuture();
        this.threadContext.execute(() -> ((CompletableFuture)function.get()).whenComplete((response, error) -> {
            if (error == null) {
                future.complete(response);
            } else {
                future.completeExceptionally((Throwable)error);
            }
        }));
        return future;
    }

    private void registerListeners() {
        this.protocol.registerAppendHandler(this::append);
        this.protocol.registerBackupHandler(this::backup);
        this.protocol.registerConsumeHandler(this::consume);
        this.protocol.registerResetConsumer(this::reset, (Executor)this.threadContext);
    }

    private void unregisterListeners() {
        this.protocol.unregisterAppendHandler();
        this.protocol.unregisterBackupHandler();
        this.protocol.unregisterConsumeHandler();
        this.protocol.unregisterResetConsumer();
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public CompletableFuture<Void> stop() {
        this.unregisterListeners();
        this.primaryElection.removeListener((EventListener)this.primaryElectionListener);
        if (this.compactTimer != null) {
            this.compactTimer.cancel();
        }
        this.journal.close();
        this.started.set(false);
        return ((CompletableFuture)this.memberGroupService.stop().exceptionally(throwable -> {
            this.log.error("Failed stopping member group service", throwable);
            return null;
        })).thenRunAsync(() -> {
            if (this.closeOnStop) {
                this.threadContextFactory.close();
            }
        });
    }
}

