/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.election.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.atomix.core.election.AsyncLeaderElector;
import io.atomix.core.election.LeaderElector;
import io.atomix.core.election.Leadership;
import io.atomix.core.election.LeadershipEvent;
import io.atomix.core.election.LeadershipEventListener;
import io.atomix.core.election.impl.BlockingLeaderElector;
import io.atomix.core.election.impl.LeaderElectorClient;
import io.atomix.core.election.impl.LeaderElectorService;
import io.atomix.primitive.AbstractAsyncPrimitive;
import io.atomix.primitive.PrimitiveRegistry;
import io.atomix.primitive.PrimitiveState;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.utils.event.Event;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class LeaderElectorProxy
extends AbstractAsyncPrimitive<AsyncLeaderElector<byte[]>, LeaderElectorService>
implements AsyncLeaderElector<byte[]>,
LeaderElectorClient {
    private final Set<LeadershipEventListener<byte[]>> leadershipChangeListeners = Sets.newCopyOnWriteArraySet();
    private final Map<String, Set<LeadershipEventListener<byte[]>>> topicListeners = Maps.newConcurrentMap();

    public LeaderElectorProxy(ProxyClient<LeaderElectorService> proxy, PrimitiveRegistry registry) {
        super(proxy, registry);
    }

    @Override
    public void onLeadershipChange(String topic, Leadership<byte[]> oldLeadership, Leadership<byte[]> newLeadership) {
        LeadershipEvent<byte[]> event = new LeadershipEvent<byte[]>(LeadershipEvent.Type.CHANGE, topic, oldLeadership, newLeadership);
        this.leadershipChangeListeners.forEach(l -> l.event((Event)event));
        Set<LeadershipEventListener<byte[]>> listenerSet = this.topicListeners.get(topic);
        if (listenerSet != null) {
            listenerSet.forEach(l -> l.event((Event)event));
        }
    }

    @Override
    public CompletableFuture<Leadership<byte[]>> run(String topic, byte[] id) {
        return this.getProxyClient().applyBy(topic, service -> service.run(topic, id));
    }

    @Override
    public CompletableFuture<Void> withdraw(String topic, byte[] id) {
        return this.getProxyClient().acceptBy(topic, service -> service.withdraw(topic, id));
    }

    @Override
    public CompletableFuture<Boolean> anoint(String topic, byte[] id) {
        return this.getProxyClient().applyBy(topic, service -> service.anoint(topic, id));
    }

    @Override
    public CompletableFuture<Boolean> promote(String topic, byte[] id) {
        return this.getProxyClient().applyBy(topic, service -> service.promote(topic, id));
    }

    @Override
    public CompletableFuture<Void> evict(byte[] id) {
        return this.getProxyClient().acceptAll(service -> service.evict(id));
    }

    @Override
    public CompletableFuture<Leadership<byte[]>> getLeadership(String topic) {
        return this.getProxyClient().applyBy(topic, service -> service.getLeadership(topic));
    }

    @Override
    public CompletableFuture<Map<String, Leadership<byte[]>>> getLeaderships() {
        return this.getProxyClient().applyAll(service -> service.getLeaderships()).thenApply(leaderships -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            leaderships.forEach(arg_0 -> ((ImmutableMap.Builder)builder).putAll(arg_0));
            return builder.build();
        });
    }

    @Override
    public synchronized CompletableFuture<Void> addListener(LeadershipEventListener<byte[]> listener) {
        return this.getProxyClient().acceptAll(service -> service.listen()).thenRun(() -> this.leadershipChangeListeners.add(listener));
    }

    @Override
    public synchronized CompletableFuture<Void> removeListener(LeadershipEventListener<byte[]> listener) {
        if (this.leadershipChangeListeners.remove(listener)) {
            return this.getProxyClient().acceptAll(service -> service.unlisten());
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized CompletableFuture<Void> addListener(String topic, LeadershipEventListener<byte[]> listener) {
        if (this.topicListeners.isEmpty()) {
            return this.getProxyClient().acceptBy(topic, service -> service.listen()).thenRun(() -> this.topicListeners.computeIfAbsent(topic, t -> Sets.newCopyOnWriteArraySet()).add(listener));
        }
        this.topicListeners.computeIfAbsent(topic, t -> Sets.newCopyOnWriteArraySet()).add(listener);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized CompletableFuture<Void> removeListener(String topic, LeadershipEventListener<byte[]> listener) {
        this.topicListeners.computeIfPresent(topic, (t, s) -> {
            s.remove(listener);
            return s.size() == 0 ? null : s;
        });
        if (this.topicListeners.isEmpty()) {
            return this.getProxyClient().acceptBy(topic, service -> service.unlisten());
        }
        return CompletableFuture.completedFuture(null);
    }

    private boolean isListening() {
        return !this.topicListeners.isEmpty();
    }

    public CompletableFuture<AsyncLeaderElector<byte[]>> connect() {
        return ((CompletableFuture)super.connect().thenRun(() -> this.getProxyClient().getPartitions().forEach(partition -> partition.addStateChangeListener(state -> {
            if (state == PrimitiveState.CONNECTED && this.isListening()) {
                partition.accept(service -> service.listen());
            }
        })))).thenApply(v -> this);
    }

    @Override
    public LeaderElector<byte[]> sync(Duration operationTimeout) {
        return new BlockingLeaderElector<byte[]>(this, operationTimeout.toMillis());
    }
}

