/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.list.impl;

import io.atomix.core.collection.impl.TranscodingAsyncDistributedCollection;
import io.atomix.core.list.AsyncDistributedList;
import io.atomix.core.list.DistributedList;
import io.atomix.core.list.impl.BlockingDistributedList;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TranscodingAsyncDistributedList<E1, E2>
extends TranscodingAsyncDistributedCollection<E1, E2>
implements AsyncDistributedList<E1> {
    private final AsyncDistributedList<E2> backingList;
    private final Function<E1, E2> elementEncoder;
    private final Function<E2, E1> elementDecoder;

    public TranscodingAsyncDistributedList(AsyncDistributedList<E2> backingList, Function<E1, E2> elementEncoder, Function<E2, E1> elementDecoder) {
        super(backingList, elementEncoder, elementDecoder);
        this.backingList = backingList;
        this.elementEncoder = k -> k == null ? null : elementEncoder.apply(k);
        this.elementDecoder = k -> k == null ? null : elementDecoder.apply(k);
    }

    @Override
    public CompletableFuture<Boolean> addAll(int index, Collection<? extends E1> c) {
        return this.backingList.addAll(index, c.stream().map(this.elementEncoder).collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<E1> get(int index) {
        return this.backingList.get(index).thenApply(this.elementDecoder);
    }

    @Override
    public CompletableFuture<E1> set(int index, E1 element) {
        return this.backingList.set(index, this.elementEncoder.apply(element)).thenApply(this.elementDecoder);
    }

    @Override
    public CompletableFuture<Void> add(int index, E1 element) {
        return this.backingList.add(index, this.elementEncoder.apply(element));
    }

    @Override
    public CompletableFuture<E1> remove(int index) {
        return this.backingList.remove(index).thenApply(this.elementDecoder);
    }

    @Override
    public CompletableFuture<Integer> indexOf(Object o) {
        return this.backingList.indexOf(this.elementEncoder.apply(o));
    }

    @Override
    public CompletableFuture<Integer> lastIndexOf(Object o) {
        return this.backingList.lastIndexOf(this.elementEncoder.apply(o));
    }

    @Override
    public DistributedList<E1> sync(Duration operationTimeout) {
        return new BlockingDistributedList(this, operationTimeout.toMillis());
    }
}

