/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.log.impl;

import com.google.common.base.Throwables;
import io.atomix.core.log.AsyncDistributedLog;
import io.atomix.core.log.DistributedLog;
import io.atomix.core.log.DistributedLogPartition;
import io.atomix.core.log.Record;
import io.atomix.core.log.impl.BlockingDistributedLogPartition;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.Synchronous;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

public class BlockingDistributedLog<E>
extends Synchronous<AsyncDistributedLog<E>>
implements DistributedLog<E> {
    private final AsyncDistributedLog<E> asyncLog;
    private final Map<Integer, DistributedLogPartition<E>> partitions = new ConcurrentHashMap<Integer, DistributedLogPartition<E>>();
    private final List<DistributedLogPartition<E>> sortedPartitions = new CopyOnWriteArrayList<DistributedLogPartition<E>>();
    private final long operationTimeoutMillis;

    public BlockingDistributedLog(AsyncDistributedLog<E> asyncLog, long operationTimeoutMillis) {
        super(asyncLog);
        this.asyncLog = asyncLog;
        this.operationTimeoutMillis = operationTimeoutMillis;
        asyncLog.getPartitions().forEach(partition -> {
            BlockingDistributedLogPartition blockingPartition = new BlockingDistributedLogPartition(partition, operationTimeoutMillis);
            this.partitions.put(blockingPartition.id(), blockingPartition);
            this.sortedPartitions.add(blockingPartition);
        });
    }

    @Override
    public List<DistributedLogPartition<E>> getPartitions() {
        return this.sortedPartitions;
    }

    @Override
    public DistributedLogPartition<E> getPartition(int partitionId) {
        return this.partitions.get(partitionId);
    }

    @Override
    public DistributedLogPartition<E> getPartition(E entry) {
        return this.getPartition((E)this.asyncLog.getPartition(entry).id());
    }

    @Override
    public void produce(E entry) {
        this.complete(this.asyncLog.produce(entry));
    }

    @Override
    public void consume(Consumer<Record<E>> consumer) {
        this.complete(this.asyncLog.consume(consumer));
    }

    @Override
    public AsyncDistributedLog<E> async() {
        return this.asyncLog;
    }

    private <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PrimitiveException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new PrimitiveException.Timeout();
        }
        catch (ExecutionException e) {
            Throwable cause = Throwables.getRootCause((Throwable)e);
            if (cause instanceof PrimitiveException) {
                throw (PrimitiveException)cause;
            }
            throw new PrimitiveException(cause);
        }
    }
}

