/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.log.impl;

import com.google.common.base.Throwables;
import io.atomix.core.log.AsyncDistributedLogPartition;
import io.atomix.core.log.DistributedLogPartition;
import io.atomix.core.log.Record;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.Synchronous;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

public class BlockingDistributedLogPartition<E>
extends Synchronous<AsyncDistributedLogPartition<E>>
implements DistributedLogPartition<E> {
    private final AsyncDistributedLogPartition<E> asyncPartition;
    private final long operationTimeoutMillis;

    public BlockingDistributedLogPartition(AsyncDistributedLogPartition<E> asyncPartition, long operationTimeoutMillis) {
        super(asyncPartition);
        this.asyncPartition = asyncPartition;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    @Override
    public int id() {
        return this.asyncPartition.id();
    }

    @Override
    public void produce(E entry) {
        this.complete(this.asyncPartition.produce(entry));
    }

    @Override
    public void consume(long offset, Consumer<Record<E>> consumer) {
        this.complete(this.asyncPartition.consume(offset, consumer));
    }

    @Override
    public AsyncDistributedLogPartition<E> async() {
        return this.asyncPartition;
    }

    private <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PrimitiveException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new PrimitiveException.Timeout();
        }
        catch (ExecutionException e) {
            Throwable cause = Throwables.getRootCause((Throwable)e);
            if (cause instanceof PrimitiveException) {
                throw (PrimitiveException)cause;
            }
            throw new PrimitiveException(cause);
        }
    }
}

