/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.map;

import com.google.common.util.concurrent.MoreExecutors;
import io.atomix.core.collection.DistributedCollection;
import io.atomix.core.map.AsyncAtomicMap;
import io.atomix.core.map.AtomicMapEventListener;
import io.atomix.core.set.DistributedSet;
import io.atomix.primitive.SyncPrimitive;
import io.atomix.utils.time.Versioned;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public interface AtomicMap<K, V>
extends SyncPrimitive {
    public int size();

    public boolean isEmpty();

    public boolean containsKey(K var1);

    public boolean containsValue(V var1);

    public Versioned<V> get(K var1);

    public Map<K, Versioned<V>> getAllPresent(Iterable<K> var1);

    public Versioned<V> getOrDefault(K var1, V var2);

    public Versioned<V> computeIfAbsent(K var1, Function<? super K, ? extends V> var2);

    public Versioned<V> compute(K var1, BiFunction<? super K, ? super V, ? extends V> var2);

    public Versioned<V> computeIfPresent(K var1, BiFunction<? super K, ? super V, ? extends V> var2);

    public Versioned<V> computeIf(K var1, Predicate<? super V> var2, BiFunction<? super K, ? super V, ? extends V> var3);

    default public Versioned<V> put(K key, V value) {
        return this.put(key, value, Duration.ZERO);
    }

    public Versioned<V> put(K var1, V var2, Duration var3);

    default public Versioned<V> putAndGet(K key, V value) {
        return this.putAndGet(key, value, Duration.ZERO);
    }

    public Versioned<V> putAndGet(K var1, V var2, Duration var3);

    public Versioned<V> remove(K var1);

    public void clear();

    public DistributedSet<K> keySet();

    public DistributedCollection<Versioned<V>> values();

    public DistributedSet<Map.Entry<K, Versioned<V>>> entrySet();

    default public Versioned<V> putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, Duration.ZERO);
    }

    public Versioned<V> putIfAbsent(K var1, V var2, Duration var3);

    public boolean remove(K var1, V var2);

    public boolean remove(K var1, long var2);

    public Versioned<V> replace(K var1, V var2);

    public boolean replace(K var1, V var2, V var3);

    public boolean replace(K var1, long var2, V var4);

    default public void addListener(AtomicMapEventListener<K, V> listener) {
        this.addListener(listener, MoreExecutors.directExecutor());
    }

    public void addListener(AtomicMapEventListener<K, V> var1, Executor var2);

    public void removeListener(AtomicMapEventListener<K, V> var1);

    public AsyncAtomicMap<K, V> async();
}

