/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.map.impl;

import io.atomix.core.map.AtomicCounterMapType;
import io.atomix.core.map.impl.AtomicCounterMapService;
import io.atomix.primitive.service.AbstractPrimitiveService;
import io.atomix.primitive.service.BackupInput;
import io.atomix.primitive.service.BackupOutput;
import java.util.HashMap;
import java.util.Map;

public class DefaultAtomicCounterMapService
extends AbstractPrimitiveService
implements AtomicCounterMapService {
    private Map<String, Long> map = new HashMap<String, Long>();

    public DefaultAtomicCounterMapService() {
        super(AtomicCounterMapType.instance());
    }

    public void backup(BackupOutput writer) {
        writer.writeObject(this.map);
    }

    public void restore(BackupInput reader) {
        this.map = (Map)reader.readObject();
    }

    private long primitive(Long value) {
        if (value != null) {
            return value;
        }
        return 0L;
    }

    @Override
    public long put(String key, long value) {
        return this.primitive(this.map.put(key, value));
    }

    @Override
    public long putIfAbsent(String key, long value) {
        return this.primitive(this.map.putIfAbsent(key, value));
    }

    @Override
    public long get(String key) {
        return this.primitive(this.map.get(key));
    }

    @Override
    public boolean replace(String key, long expectedOldValue, long newValue) {
        Long value = this.map.get(key);
        if (value == null) {
            if (expectedOldValue == 0L) {
                this.map.put(key, newValue);
                return true;
            }
            return false;
        }
        if (value == expectedOldValue) {
            this.map.put(key, newValue);
            return true;
        }
        return false;
    }

    @Override
    public long remove(String key) {
        return this.primitive(this.map.remove(key));
    }

    @Override
    public boolean remove(String key, long value) {
        Long oldValue = this.map.get(key);
        if (oldValue == null) {
            if (value == 0L) {
                this.map.remove(key);
                return true;
            }
            return false;
        }
        if (oldValue == value) {
            this.map.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public long getAndIncrement(String key) {
        long value = this.primitive(this.map.get(key));
        this.map.put(key, value + 1L);
        return value;
    }

    @Override
    public long getAndDecrement(String key) {
        long value = this.primitive(this.map.get(key));
        this.map.put(key, value - 1L);
        return value;
    }

    @Override
    public long incrementAndGet(String key) {
        long value = this.primitive(this.map.get(key));
        this.map.put(key, ++value);
        return value;
    }

    @Override
    public long decrementAndGet(String key) {
        long value = this.primitive(this.map.get(key));
        this.map.put(key, --value);
        return value;
    }

    @Override
    public long addAndGet(String key, long delta) {
        long value = this.primitive(this.map.get(key));
        this.map.put(key, value += delta);
        return value;
    }

    @Override
    public long getAndAdd(String key, long delta) {
        long value = this.primitive(this.map.get(key));
        this.map.put(key, value + delta);
        return value;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

