/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.map.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.atomix.core.collection.AsyncDistributedCollection;
import io.atomix.core.collection.impl.TranscodingAsyncDistributedCollection;
import io.atomix.core.map.AsyncAtomicMap;
import io.atomix.core.map.AtomicMap;
import io.atomix.core.map.AtomicMapEvent;
import io.atomix.core.map.AtomicMapEventListener;
import io.atomix.core.map.impl.BlockingAtomicMap;
import io.atomix.core.map.impl.MapUpdate;
import io.atomix.core.set.AsyncDistributedSet;
import io.atomix.core.set.impl.TranscodingAsyncDistributedSet;
import io.atomix.core.transaction.TransactionId;
import io.atomix.core.transaction.TransactionLog;
import io.atomix.primitive.impl.DelegatingAsyncPrimitive;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.event.Event;
import io.atomix.utils.time.Versioned;
import java.time.Duration;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class TranscodingAsyncAtomicMap<K1, V1, K2, V2>
extends DelegatingAsyncPrimitive
implements AsyncAtomicMap<K1, V1> {
    private final AsyncAtomicMap<K2, V2> backingMap;
    protected final Function<K1, K2> keyEncoder;
    protected final Function<K2, K1> keyDecoder;
    protected final Function<V2, V1> valueDecoder;
    protected final Function<V1, V2> valueEncoder;
    protected final Function<Versioned<V2>, Versioned<V1>> versionedValueDecoder;
    protected final Function<Versioned<V1>, Versioned<V2>> versionedValueEncoder;
    protected final Function<Map.Entry<K2, Versioned<V2>>, Map.Entry<K1, Versioned<V1>>> entryDecoder;
    protected final Function<Map.Entry<K1, Versioned<V1>>, Map.Entry<K2, Versioned<V2>>> entryEncoder;
    private final Map<AtomicMapEventListener<K1, V1>, InternalBackingAtomicMapEventListener> listeners = Maps.newIdentityHashMap();

    public TranscodingAsyncAtomicMap(AsyncAtomicMap<K2, V2> backingMap, Function<K1, K2> keyEncoder, Function<K2, K1> keyDecoder, Function<V1, V2> valueEncoder, Function<V2, V1> valueDecoder) {
        super(backingMap);
        this.backingMap = backingMap;
        this.keyEncoder = k -> k == null ? null : keyEncoder.apply(k);
        this.keyDecoder = k -> k == null ? null : keyDecoder.apply(k);
        this.valueEncoder = v -> v == null ? null : valueEncoder.apply(v);
        this.valueDecoder = v -> v == null ? null : valueDecoder.apply(v);
        this.versionedValueDecoder = v -> v == null ? null : v.map(valueDecoder);
        this.versionedValueEncoder = v -> v == null ? null : v.map(valueEncoder);
        this.entryDecoder = e -> e == null ? null : Maps.immutableEntry(keyDecoder.apply(e.getKey()), this.versionedValueDecoder.apply((Versioned<V2>)e.getValue()));
        this.entryEncoder = e -> e == null ? null : Maps.immutableEntry(keyEncoder.apply(e.getKey()), this.versionedValueEncoder.apply((Versioned<V1>)e.getValue()));
    }

    @Override
    public CompletableFuture<Integer> size() {
        return this.backingMap.size();
    }

    @Override
    public CompletableFuture<Boolean> containsKey(K1 key) {
        try {
            return this.backingMap.containsKey(this.keyEncoder.apply(key));
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Boolean> containsValue(V1 value) {
        try {
            return this.backingMap.containsValue(this.valueEncoder.apply(value));
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Versioned<V1>> get(K1 key) {
        try {
            return this.backingMap.get(this.keyEncoder.apply(key)).thenApply(this.versionedValueDecoder);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Map<K1, Versioned<V1>>> getAllPresent(Iterable<K1> keys) {
        try {
            HashSet<K2> uniqueKeys = new HashSet<K2>();
            for (K1 key : keys) {
                uniqueKeys.add(this.keyEncoder.apply(key));
            }
            return this.backingMap.getAllPresent(uniqueKeys).thenApply(entries -> ImmutableMap.copyOf(entries.entrySet().stream().collect(Collectors.toMap(o -> this.keyDecoder.apply(o.getKey()), o -> this.versionedValueDecoder.apply((Versioned<V2>)o.getValue())))));
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Versioned<V1>> getOrDefault(K1 key, V1 defaultValue) {
        try {
            return this.backingMap.getOrDefault(this.keyEncoder.apply(key), this.valueEncoder.apply(defaultValue)).thenApply(this.versionedValueDecoder);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Versioned<V1>> computeIf(K1 key, Predicate<? super V1> condition, BiFunction<? super K1, ? super V1, ? extends V1> remappingFunction) {
        try {
            return this.backingMap.computeIf(this.keyEncoder.apply(key), (? super V v) -> condition.test((V1)this.valueDecoder.apply(v)), (? super K k, ? super V v) -> this.valueEncoder.apply(remappingFunction.apply((K1)this.keyDecoder.apply(k), (V1)this.valueDecoder.apply(v)))).thenApply(this.versionedValueDecoder);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Versioned<V1>> put(K1 key, V1 value, Duration ttl) {
        try {
            return this.backingMap.put(this.keyEncoder.apply(key), this.valueEncoder.apply(value), ttl).thenApply(this.versionedValueDecoder);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Versioned<V1>> putAndGet(K1 key, V1 value, Duration ttl) {
        try {
            return this.backingMap.putAndGet(this.keyEncoder.apply(key), this.valueEncoder.apply(value), ttl).thenApply(this.versionedValueDecoder);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Versioned<V1>> remove(K1 key) {
        try {
            return this.backingMap.remove(this.keyEncoder.apply(key)).thenApply(this.versionedValueDecoder);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Void> clear() {
        return this.backingMap.clear();
    }

    @Override
    public AsyncDistributedSet<K1> keySet() {
        return new TranscodingAsyncDistributedSet<K1, K2>(this.backingMap.keySet(), this.keyEncoder, this.keyDecoder);
    }

    @Override
    public AsyncDistributedCollection<Versioned<V1>> values() {
        return new TranscodingAsyncDistributedCollection<Versioned<V1>, Versioned<V2>>(this.backingMap.values(), this.versionedValueEncoder, this.versionedValueDecoder);
    }

    @Override
    public AsyncDistributedSet<Map.Entry<K1, Versioned<V1>>> entrySet() {
        return new TranscodingAsyncDistributedSet<Map.Entry<K1, Versioned<V1>>, Map.Entry<K2, Versioned<V2>>>(this.backingMap.entrySet(), this.entryEncoder, this.entryDecoder);
    }

    @Override
    public CompletableFuture<Versioned<V1>> putIfAbsent(K1 key, V1 value, Duration ttl) {
        try {
            return this.backingMap.putIfAbsent(this.keyEncoder.apply(key), this.valueEncoder.apply(value), ttl).thenApply(this.versionedValueDecoder);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Boolean> remove(K1 key, V1 value) {
        try {
            return this.backingMap.remove(this.keyEncoder.apply(key), this.valueEncoder.apply(value));
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Boolean> remove(K1 key, long version) {
        try {
            return this.backingMap.remove(this.keyEncoder.apply(key), version);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Versioned<V1>> replace(K1 key, V1 value) {
        try {
            return this.backingMap.replace(this.keyEncoder.apply(key), this.valueEncoder.apply(value)).thenApply(this.versionedValueDecoder);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Boolean> replace(K1 key, V1 oldValue, V1 newValue) {
        try {
            return this.backingMap.replace(this.keyEncoder.apply(key), this.valueEncoder.apply(oldValue), this.valueEncoder.apply(newValue));
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Boolean> replace(K1 key, long oldVersion, V1 newValue) {
        try {
            return this.backingMap.replace(this.keyEncoder.apply(key), oldVersion, this.valueEncoder.apply(newValue));
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> addListener(AtomicMapEventListener<K1, V1> listener, Executor executor) {
        Map<AtomicMapEventListener<K1, V1>, InternalBackingAtomicMapEventListener> map = this.listeners;
        synchronized (map) {
            InternalBackingAtomicMapEventListener backingMapListener = this.listeners.computeIfAbsent(listener, k -> new InternalBackingAtomicMapEventListener(listener));
            return this.backingMap.addListener(backingMapListener, executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> removeListener(AtomicMapEventListener<K1, V1> listener) {
        Map<AtomicMapEventListener<K1, V1>, InternalBackingAtomicMapEventListener> map = this.listeners;
        synchronized (map) {
            InternalBackingAtomicMapEventListener backingMapListener = this.listeners.remove(listener);
            if (backingMapListener != null) {
                return this.backingMap.removeListener(backingMapListener);
            }
            return CompletableFuture.completedFuture(null);
        }
    }

    @Override
    public CompletableFuture<Boolean> prepare(TransactionLog<MapUpdate<K1, V1>> transactionLog) {
        try {
            return this.backingMap.prepare(transactionLog.map(record -> record.map(this.keyEncoder, this.valueEncoder)));
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Void> commit(TransactionId transactionId) {
        try {
            return this.backingMap.commit(transactionId);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Void> rollback(TransactionId transactionId) {
        try {
            return this.backingMap.rollback(transactionId);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public AtomicMap<K1, V1> sync(Duration operationTimeout) {
        return new BlockingAtomicMap(this, operationTimeout.toMillis());
    }

    private class InternalBackingAtomicMapEventListener
    implements AtomicMapEventListener<K2, V2> {
        private final AtomicMapEventListener<K1, V1> listener;

        InternalBackingAtomicMapEventListener(AtomicMapEventListener<K1, V1> listener) {
            this.listener = listener;
        }

        public void event(AtomicMapEvent<K2, V2> event) {
            this.listener.event((Event)new AtomicMapEvent((AtomicMapEvent.Type)event.type(), TranscodingAsyncAtomicMap.this.keyDecoder.apply(event.key()), event.newValue() != null ? event.newValue().map(TranscodingAsyncAtomicMap.this.valueDecoder) : null, event.oldValue() != null ? event.oldValue().map(TranscodingAsyncAtomicMap.this.valueDecoder) : null));
        }
    }
}

