/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.registry;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.atomix.cluster.discovery.NodeDiscoveryProvider;
import io.atomix.cluster.protocol.GroupMembershipProtocol;
import io.atomix.core.AtomixRegistry;
import io.atomix.core.profile.Profile;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.partition.PartitionGroup;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.utils.NamedType;
import io.atomix.utils.ServiceException;
import io.atomix.utils.misc.StringUtils;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathScanningRegistry
implements AtomixRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathScanningRegistry.class);
    private static final Collection<Class<? extends NamedType>> TYPES = Arrays.asList(PartitionGroup.Type.class, PrimitiveType.class, PrimitiveProtocol.Type.class, Profile.Type.class, NodeDiscoveryProvider.Type.class);
    private static final Map<ClassLoader, Map<CacheKey, Map<Class<? extends NamedType>, Map<String, NamedType>>>> CACHE = Collections.synchronizedMap(new WeakHashMap());
    private final Map<Class<? extends NamedType>, Map<String, NamedType>> registrations = new ConcurrentHashMap<Class<? extends NamedType>, Map<String, NamedType>>();

    public static Builder builder() {
        return new Builder();
    }

    private ClasspathScanningRegistry(ClassLoader classLoader) {
        this(classLoader, TYPES, Sets.newHashSet());
    }

    private ClasspathScanningRegistry(ClassLoader classLoader, Collection<Class<? extends NamedType>> types, Set<String> whitelistPackages) {
        Map mappings = CACHE.computeIfAbsent(classLoader, cl -> new ConcurrentHashMap());
        Map registrations = mappings.computeIfAbsent(new CacheKey(types.toArray(new Class[0])), cacheKey -> {
            ClassGraph classGraph = !whitelistPackages.isEmpty() ? new ClassGraph().enableClassInfo().whitelistPackages(whitelistPackages.toArray(new String[0])).addClassLoader(classLoader) : new ClassGraph().enableClassInfo().addClassLoader(classLoader);
            try (ScanResult scanResult = classGraph.scan();){
                ConcurrentHashMap result = new ConcurrentHashMap();
                for (Class type : ((CacheKey)cacheKey).types) {
                    ConcurrentHashMap tmp = new ConcurrentHashMap();
                    scanResult.getClassesImplementing(type.getName()).forEach(classInfo -> {
                        if (classInfo.isInterface() || classInfo.isAbstract() || Modifier.isPrivate(classInfo.getModifiers())) {
                            return;
                        }
                        NamedType instance = (NamedType)ClasspathScanningRegistry.newInstance(classInfo.loadClass());
                        NamedType oldInstance = tmp.put(instance.name(), instance);
                        if (oldInstance != null) {
                            LOGGER.warn("Found multiple types with name={}, classes=[{}, {}]", new Object[]{instance.name(), oldInstance.getClass().getName(), instance.getClass().getName()});
                        }
                    });
                    result.put(type, Collections.unmodifiableMap(tmp));
                }
                ConcurrentHashMap concurrentHashMap = result;
                return concurrentHashMap;
            }
        });
        this.registrations.putAll(registrations);
    }

    private static <T> T newInstance(Class<?> type) {
        try {
            return (T)type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ServiceException("Cannot instantiate service class " + type, (Throwable)e);
        }
    }

    @Override
    public <T extends NamedType> Collection<T> getTypes(Class<T> type) {
        Map<String, NamedType> types = this.registrations.get(type);
        return types != null ? types.values() : Collections.emptyList();
    }

    @Override
    public <T extends NamedType> T getType(Class<T> type, String name) {
        Map<String, NamedType> types = this.registrations.get(type);
        return (T)(types != null ? types.get(name) : null);
    }

    public static class Builder
    implements io.atomix.utils.Builder<AtomixRegistry> {
        private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        private Set<String> whitelistPackages = Sets.newHashSet();

        private Builder() {
            String whitelistPackages = System.getProperty("io.atomix.whitelistPackages");
            if (whitelistPackages != null) {
                this.whitelistPackages = Sets.newHashSet((Object[])StringUtils.split((String)whitelistPackages, (String)","));
            }
        }

        public Builder withClassLoader(ClassLoader classLoader) {
            this.classLoader = (ClassLoader)Preconditions.checkNotNull((Object)classLoader, (Object)"classLoader cannot be null");
            return this;
        }

        public Builder withWhitelistPackages(String ... whitelistPackages) {
            return this.withWhitelistPackages(Sets.newHashSet((Object[])whitelistPackages));
        }

        public Builder withWhitelistPackages(Collection<String> whitelistPackages) {
            this.whitelistPackages = Sets.newHashSet(whitelistPackages);
            return this;
        }

        public Builder addWhitelistPackage(String whitelistPackage) {
            Preconditions.checkNotNull((Object)whitelistPackage, (Object)"whitelistPackage cannot be null");
            this.whitelistPackages.add(whitelistPackage);
            return this;
        }

        public AtomixRegistry build() {
            return new ClasspathScanningRegistry(this.classLoader, Arrays.asList(PartitionGroup.Type.class, PrimitiveType.class, PrimitiveProtocol.Type.class, Profile.Type.class, NodeDiscoveryProvider.Type.class, GroupMembershipProtocol.Type.class), this.whitelistPackages);
        }
    }

    private static final class CacheKey {
        private final Class<? extends NamedType>[] types;

        CacheKey(Class<? extends NamedType>[] types) {
            this.types = types;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Arrays.equals(this.types, cacheKey.types);
        }

        public int hashCode() {
            return Arrays.hashCode(this.types);
        }
    }
}

