/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.transaction.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.core.map.AsyncAtomicMap;
import io.atomix.core.map.impl.MapUpdate;
import io.atomix.core.transaction.AsyncTransactionalMap;
import io.atomix.core.transaction.TransactionId;
import io.atomix.core.transaction.TransactionParticipant;
import io.atomix.core.transaction.TransactionalMap;
import io.atomix.core.transaction.impl.BlockingTransactionalMap;
import io.atomix.primitive.PrimitiveType;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public abstract class TransactionalMapParticipant<K, V>
implements AsyncTransactionalMap<K, V>,
TransactionParticipant<MapUpdate<K, V>> {
    protected final TransactionId transactionId;
    protected final AsyncAtomicMap<K, V> consistentMap;

    protected TransactionalMapParticipant(TransactionId transactionId, AsyncAtomicMap<K, V> consistentMap) {
        this.transactionId = (TransactionId)((Object)Preconditions.checkNotNull((Object)((Object)transactionId)));
        this.consistentMap = (AsyncAtomicMap)Preconditions.checkNotNull(consistentMap);
    }

    public String name() {
        return this.consistentMap.name();
    }

    public PrimitiveType type() {
        return this.consistentMap.type();
    }

    @Override
    public CompletableFuture<Boolean> prepare() {
        return this.consistentMap.prepare(this.log());
    }

    @Override
    public CompletableFuture<Void> commit() {
        return this.consistentMap.commit(this.transactionId);
    }

    @Override
    public CompletableFuture<Void> rollback() {
        return this.consistentMap.rollback(this.transactionId);
    }

    @Override
    public CompletableFuture<Void> close() {
        return this.consistentMap.close();
    }

    public CompletableFuture<Void> delete() {
        return this.consistentMap.delete();
    }

    @Override
    public TransactionalMap<K, V> sync(Duration operationTimeout) {
        return new BlockingTransactionalMap(this, operationTimeout.toMillis());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).toString();
    }
}

